#include "mbed.h"
#include "keypad.h"

Button::Button(PinName pin, void (*cbFunc)(void)) :
_interrupt(pin)
{        
    _interrupt.rise(cbFunc);
}

Keypad::Keypad( PinName pinLeft, void (*cbLeft)(void),
            PinName pinRight, void (*cbRight)(void),
            PinName pinStart, void (*cbStart)(void),
            PinName pinStop, void (*cbStop)(void),
            PinName pinDoor, void (*cbDoor)(void) ) :
left(pinLeft, cbLeft),
right(pinRight, cbRight),
start(pinStart, cbStart),
stop(pinStop, cbStop),
door(pinDoor, cbDoor)
{
}

