#ifndef __KEYPAD_H__
#define __KEYPAD_H__

#include "mbed.h"

class Button
{
public:
    Button(PinName pin, void (*cbFunc)(void));
    ~Button() {};
private:
    InterruptIn _interrupt;
};

class Keypad
{
public:
    Keypad( PinName pinLeft, void (*cbLeft)(void),
            PinName pinRight, void (*cbRight)(void),
            PinName pinStart, void (*cbStart)(void),
            PinName pinStop, void (*cbStop)(void),
            PinName pinDoor, void (*cbDoor)(void) );
    ~Keypad() {};
private:
    Button left;
    Button right;
    Button start;
    Button stop;
    Button door;       
};

#endif /* __KEYPAD_H__ */