#include "at24c1024b.h"

AT24C1024B::AT24C1024B(PinName sda, PinName scl, int addr) :
    SDA(sda), SCL(scl), i2c(sda, scl)
{
    
}
AT24C1024B::AT24C1024B(PinName sda, PinName scl) :
    SDA(sda), SCL(scl), i2c(sda, scl)
{
}
AT24C1024B::AT24C1024B(PinName sda, PinName scl) :
    SDA(sda), SCL(scl), i2c(sda, scl)
{
}
AT24C1024B::AT24C1024B(PinName sda, PinName scl) :
    SDA(sda), SCL(scl), i2c(sda, scl)
{
}

int AT24C1024B::write(int addr, int page, char data)
{
    char array[1]=data;
    int buff;
    buff = write(addr, page, array, 1);
    return buff;
}

int AT24C1024B::write(int addr, int page, char *data, int length)
{
    char buffCommand[2];
    if(length<1) {
        return -1;
    }
    buffCommand[0]=(char)addr&0xff00;//上位8ビットを代入
    buffCommand[1]=(char)addr&0x00ff;//下位8ビットを代入
    i2c.write(AT24C1024B_ADDRESS,buffCommand,2,true);//次の書き込み命令と同時に送信
    i2c.write(AT24C1024B_ADDRESS,data,length);
    wait(0.005);
}

int read(int addr, int page)
{
    char array[1]=data;
    read(addr, page, array, 1);
    return array[0];
}

int AT24C1024B::read(int addr, int page, char *data, int length)
{
    char buffCommand[2];
    if(length<1) {
        return -1;
    }
    buffCommand[0]=(char)addr&0xff00;//上位8ビットを代入
    buffCommand[1]=(char)addr&0x00ff;//下位8ビットを代入
    i2c.write(AT24C1024B_ADDRESS,buffCommand,2);
    i2c.read(AT24C1024B_ADDRESS,data,length);
    return 0;
}

