//Project_02
#include "mbed.h"
#include "TextLCD.h"
#include "Servo.h"
#include "ds1307.h"

DigitalOut ledr(p5);                        //RGB led rood
DigitalOut ledg(p6);                        //RGB led groen
DigitalOut ledb(p7);                        //RGB led blauw
DigitalOut relais(p8);                      //Relais
DS1307 my1307(p9,p10);                      //start DS1307 class and give it pins for connections of the DS1307 device
InterruptIn push1(p11);                     //drukknop onder interrupt mogelijk (hoger)
InterruptIn push2(p12);                     //drukknop onder interrupt mogelijk (lager)
InterruptIn push3(p13);                     //drukknop onder interrupt mogelijk (bevestigen)
InterruptIn push4(p14);                     //drukknop onder interrupt mogelijk (anuleren)
AnalogIn temp01(p19);                       //LM35 Binnen
AnalogIn temp02(p20);                       //LM35 Buiten
PwmOut myservo(p22);                        //Servo motor met pwm
PwmOut LCDBack(p21);                        //backlight LCD control
TextLCD lcd(p25, p26, p27, p28, p29, p30);  //LCD

float licht=0;                      //backlight
float vorig_licht=0;                //backlight onthouden van waarde
float i=0;                          //temperatuur 01
float j=0;                          //temperatuur 02
float ingesteld=21;                 //ingestelde temperatuur
float vorige_instelling=21;         //ingestelde temperatuur onthouden van waarde

int sec;                            //RTC
int min;                            //RTC
int hours;                          //RTC
int day;                            //RTC
int date;                           //RTC
int month;                          //RTC
int year;                           //RTC

void test_rw(int test) {                    //RTC Klok
}

void menu(void){    
    lcd.cls();                              //Menu load screen (anti dender, als de knop te lang word
    lcd.locate(0,0);                        //ingedrukt kan dit per ongeluk al een volgende functie
    lcd.printf("******Menu******");         //starten vandaar dit load screen om dit te vermijden.
    lcd.locate(0,1);                        //men kan ook gewoon een wait plaatsen van een seconde.)
    lcd.printf("Laden .");                  //en clear LCD
    wait(0.5);  
    lcd.locate(0,1);
    lcd.printf("Laden ..");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("Laden ...");
    wait(0.5);
    while(push4 == 0){                                  //while anuleren niet is in gedrukt
        while(push1 == 0 && push2 == 0 && push4 == 0){  //while drukknoppen 1,2 en 4 niet ingedrukt zijn
            ledr = 0;                                   //aansturing RGB led
            ledg = 0;
            ledb = 0;
            lcd.cls();                                  //keuze menu weergeven en clear LCD
            lcd.locate(0,0);                            //Plaats LCD cursor op de juiste plaats
            lcd.printf("******Menu******");
            lcd.locate(0,1);
            lcd.printf("1: Helderheid");
            wait(1);
            lcd.cls();                                  //clear LCD
            lcd.locate(0,0);
            lcd.printf("******Menu******");
            lcd.locate(0,1);
            lcd.printf("4: Terug");
            wait(1);
        }
        if(push1 == 1){                         //als drukknop 1 word ingedrukt
            lcd.cls();                          //Drukknop info weergeven en clear LCD
            lcd.locate(0,0);
            lcd.printf("Menu: Helderheid");
            lcd.locate(0,1);
            lcd.printf("<+ -> bev. anu.");
            wait(0.5); 
            vorig_licht = licht;                //vergrendel de vorige waarde van licht indien er word geanuleerd
            while(push3 == 0 && push4 == 0){    //while drukknoppen 3 en 4 niet ingedrukt zijn
                LCDBack = licht;                //geef de backlight de waarde van licht
                if(push1 == 1){                 //Als drukknop 1 word ingedrukt
                    licht = licht - 0.05;       //Licht doen toenemen, de variabele word verkleint
                    ledr = 1;                   //aansturen led voor indicatie toename
                    ledg = 1;
                    ledb = 0;
                    if(licht <= 0){             //Als licht kleiner of gelijk aan 0 is word de waarde automatisch
                        licht = 0;              //terug 0, dit zorgt er voor dat de waarde steeds tussen 0 en 1 blijft.
                    }
                    wait(0.2);
                }
                if(push2 == 1){                 //Als drukknop 2 word ingedrukt
                    licht = licht + 0.05;       //Licht doen afnemen, de variabele word vergroot
                    ledr = 0;                   //aansturen led voor indicatie afname
                    ledg = 1;
                    ledb = 1;
                    if(licht >= 1){             //Als licht groter of gelijk aan 1 is word de waarde automatisch
                        licht = 1;              //terug 1, dit zorgt er voor dat de waarde steeds tussen 0 en 1 blijft.
                    }
                    wait(0.2);
                }
                wait(0.5);    
            }
            if(push4 == 1){                     //Als drukknop 4 ingedrukt word (Anulatie)
                licht = vorig_licht;            //licht krijgt de vorige waarde terug
            }
        }
    }
    if(push3 == 1){                 //Als drukknop 3 ingedrukt word (Bevestiging)
        lcd.cls();                  //indicatie bevestiging op LCD en clear LCD
        lcd.locate(0,0);
        lcd.printf("Invoer");
        lcd.locate(0,1);
        lcd.printf("bevestigd");
        wait(2);
    }
    push1.rise(NULL);           //Verwijder interupt flags
    push2.rise(NULL);
    push3.rise(NULL);
    push4.rise(NULL);
    LCDBack = licht;            //Backlight aansturen
    lcd.cls();                  //indicatie voor verlaten van menu en clear LCD
    lcd.locate(0,0);
    lcd.printf("Terug naar");
    lcd.locate(0,1);
    lcd.printf("programma");
    wait(2);

}

void instelling(){
    wait(2);    
    lcd.cls();                                      //clear LCD                                          
    lcd.printf("instelling %1.1f", ingesteld);      //plaats ingestelde waarde op LCD
    vorige_instelling = ingesteld;                  //vergrendel de vorige waarde van ingesteld indien er word geanuleerd
    while(push3 == 0 && push4 == 0){                //while drukknoppen 3 en 4 niet ingedrukt zijn
        ledr = 0;                                   //aansturen led
        ledg = 0;
        ledb = 0;
        lcd.locate(0,1);                            //bepaal cursor locatie LCD
        lcd.printf("naar --> %1.1f", ingesteld);    //plaats de nieuwe waarde op het LCD
        if(push1 == 1){                             //Als drukknop 1 ingedrukt word
            ingesteld = ingesteld + 0.5;            //ingestelde waarde laten toenemen
            ledr = 1;                               //aansturen led voor indicatie toename
            ledg = 0;
            ledb = 0;
            wait(0.5);
        }
        if(push2 == 1){                             //Als drukknop 2 ingedrukt word
            ingesteld = ingesteld - 0.5;            //ingestelde waarde laten afnemen
            ledr = 0;                               //aansturen led voor indicatie afname
            ledg = 0;
            ledb = 1;
            wait(0.5);
        }
        wait(0.5);    
    }
    if(push4 == 1){                                 //Als drukknop 4 ingedrukt word (Anulatie)
        ingesteld = vorige_instelling;              //de ingestelde waarde verkrijgt de vorige waarde terug
    }
    push1.rise(NULL);       //Verwijder interupt flags
    push2.rise(NULL);
    push3.rise(NULL);
    push4.rise(NULL);
    lcd.cls();                  //indicatie voor verlaten van menu en clear LCD
    lcd.locate(0,0);
    lcd.printf("Terug naar");
    lcd.locate(0,1);
    lcd.printf("programma");
    wait(2);
}

int main(){
    int junk = 0;                           //RTC Klok
    
    myservo = (5 * 0.000511 + 0.026);       //Motor op 90 graden zetten, dit is de begin toestand.
    lcd.cls();                              //clear LCD
    lcd.printf("Welkom");                   //Welkom scherm
    lcd.locate(0,1);
    lcd.printf("Opstarten ...");
    wait(3);
    while(1){
        push1.rise(&instelling);            //drukknooppen 1 tot en met 3 onder interrupt
        push2.rise(&instelling);
        push3.rise(&menu);
        
        test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));       //uitlezen waarde RTC
        
        junk = 0x39;                            // just a junk value do read and write test to DS1307 ram
        test_rw(my1307.write( 0x20, junk));     // this should write the value of junk to register 0x20 (a ram location) in the ds1307.
        junk = 0;                               // clear junk to show that when the register is read from the correct value is obtained
        test_rw(my1307.read( 0x20, &junk));     // this should read register 0x20
        
        LCDBack = licht;                        //Backlight aansturen
        lcd.cls();                              //clear LCD
        lcd.locate(0,0);
        lcd.printf("%d/%d/%d   %d:%d",date,month,year,hours,min);           //print de datum en de tijd
        lcd.locate(0,1);
        lcd.printf("<+ -> menu");
        wait(5);
        i=0;                                                                //maak de float i 0. (nodig voor de temperatuursmeting)
        for(int t=0; t<100; t++) i=i+temp01.read();                         //en meten van temperatuur binnen
        j=0;                                                                //maak de float j 0. (nodig voor de temperatuursmeting)
        for(int u=0; u<100; u++) j=j+temp02.read();                         //en meten van temperatuur buiten
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Binnen: %4.1fC ", i*3.3);                               //print de temperatuurswaarde op de LCD
        lcd.locate(0,1);
        lcd.printf("Buiten: %4.1fC ", j*3.3);       
        wait(5);
        if(i*3.3 < ingesteld){                  //Als de temperatuur kleiner is dan de ingestelde waarde
            ledr = 0;                           //aansturen RGB led
            ledg = 1;
            ledb = 0;
            relais = 1;                         //Relais hoog maken
            //myservo = 0;
            lcd.cls();                          //clear LCD             
            lcd.locate(0,0);
            lcd.printf("ingesteld: %1.1f", ingesteld);              //print de ingestelde waarde op het LCD
            lcd.locate(0,1);
            lcd.printf("Verwarming: aan");                          //print de status van de verwarming op het LCD
            
            myservo = (170 * 0.000511 + 0.026);                     //Motor op 0 graden zetten, dit is de begin toestand.
            wait(2);
                        
        }
        if(i*3.3 >= ingesteld){                 //Als de temperatuur grotere of gelijk is aan de ingestelde waarde
            ledr = 1;                           //aansturen RGB led
            ledg = 0;
            ledb = 0;
            relais = 0;                         //Relais laag maken
            //myservo = 1;
            lcd.cls();                          //clear LCD
            lcd.locate(0,0);
            lcd.printf("ingesteld: %1.1f", ingesteld);              //print de ingestelde waarde op het LCD
            lcd.locate(0,1);
            lcd.printf("Verwarming: uit");                          //print de status van de verwarming op het LCD
            
            myservo = (5 * 0.000511 + 0.026);                       //Motor op 0 graden zetten, dit is de begin toestand.
            wait(2);
            
        }
        wait(3);
    }
}