#ifndef TOGGLE_H
#define TOGGLE_H

#include "mbed.h"


/** Toggle pin for debugging purposes
*
* Example:
* @code
* #include "mbed.h"
* #include "toggle.h"
*
* Toggle pin(P1_24);
* Toggle led(P1_25);
*
* main()
* {
*
*    while(1) {
*        pin.toggle(5);  // toggle pin 5 times
*        wait(1);
*        led.toggle(3);  // toggle led 3 times
*        wait(0.5);
*    }
*    
* }
* @endcode
*/


class Toggle
{
public:

    /**
      * toggle constructor
      *
      * @param pin  "pin" to toggle
      */
    Toggle(PinName pin);


    /**
    * Command to n times toggle the pin
    */

    void toggle(int n);




private:

    /**
     * Set the Digital out pin
     */

    DigitalOut _p;
};

#endif
