#include "mbed.h"
#include <stdarg.h>
#include "MCC0G42005A6W.h"

// Note on I2C pull up resistors  These should not be too low otherwise the display will
// not pull the SDA line low enough to register an ACK.  Suggest 10K.
// based on  Text LCD module "SB1602E" class library  @author  Tedd OKANO, Masato YAMANISHI & Toyomasa Watarai


LCD_COG::LCD_COG( PinName I2C_sda, PinName I2C_scl, const char *init_message ) : i2c_p( new I2C( I2C_sda, I2C_scl ) ), i2c( *i2c_p ), charsInLine( MaxCharsInALine )
{
    init( init_message );
    i2c.frequency(50000);

}

LCD_COG::LCD_COG( I2C &i2c_, const char *init_message ) : i2c_p( NULL ), i2c( i2c_ ), charsInLine( MaxCharsInALine )
{
    init( init_message );
    i2c.frequency(50000);    
}

LCD_COG::~LCD_COG()
{
    if ( NULL != i2c_p )
        delete  i2c_p;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::init( const char *init_message )
{

    const char init_seq0[]  = {

        0x3A,    // 8-Bit data length extension Bit RE=1; REV=0                                send_command(0x3a); // 8bit, 4line, IS=0, RE=1
        // 0x09,    // 4 line display //??????
        TOPVIEW, // Bottom view       view bottom view(0x06), top view (0x05)  BOTTOMVIEW
        0x1E,    // Bias setting BS1=1                                                         send_command(0x1e); // set BS1 (1/6 bias)
        0x39,    // 8-Bit data length extension Bit RE=0; IS=1                                 send_command(0x39); // 8bit, 4line, IS=1 , RE=0
        0x1c,    // BS0=1 -> Bias=1/6                                                          send_command(0x1c); // set BS0 (1/6 bias) + osc
        0x6d,    // 0110 Set DON and amp ratio                                                 send_command(0x6d); // Set DON and amp ratio
        0x5d,    // 0101 Set ION, BON, contrast bits 4&5                                       send_command(0x5d); // Set ION, BON, contrast bits 4&5
        0x79,    // Set contrast (DB3-DB0=C3-C0)                                               send_command(0x79); // Set contrast lower 4bits
        0x38,    // 8-Bit data length extension Bit RE=0; IS=0
        Comm_DisplayOnOff,
        Comm_ClearDisplay,
        Comm_EntryModeSet,
    };

    //  i2c_addr    = SLAVEADRESS;

    wait( 0.04 );    // 40ms    interval after hardware reset

    for ( unsigned int i = 0; i < sizeof( init_seq0 ); i++ ) {
        lcd_command( init_seq0[ i ] );
        wait(30e-6);// // 30e-6  0.00003 30ns ?  
    }

    set_CGRAM( 7, '\x1F' );

    curs[0] = 0;
    curs[1] = 0;
    curs[2] = 0;
    curs[3] = 0;

    if ( init_message ) {
        //i2c.frequency(100000);
        puts( 0, init_message );
        curs[0] = 0;
//        puts( 1, "Dit is de 2e regel 2" ); curs[1] = 0;
//        puts( 2, "Dit is de 3e regel 3" ); curs[2] = 0;
//        puts( 3, "Dit is de 4e regel 4" ); curs[3] = 0;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::printf( const char line, const char *format, ... )
{
    char    s[ 32 ];
    va_list args;

    va_start( args, format );
    vsnprintf( s, 32, format, args );
    va_end( args );

    puts( line, s );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LCD_COG::printf( char x, unsigned char y, const char *format, ... )
{
    char    s[ 32 ];
    va_list args;

    va_start( args, format );
    vsnprintf( s, 32, format, args );
    va_end( args );

    curs[ y ] = x;
    puts( y, s );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::putc( unsigned char line, char c )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    if ( (c == '\n') || (c == '\r') ) {
        clear_rest_of_line( line );
        curs[ line ]    = 0;
        return;
    }

    putcxy( c, curs[line]++, line );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::puts( char line, const char *s )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    while ( char c    = *s++ )
        putc( line, c );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::putcxy( char c, unsigned char x, unsigned char y )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    const char    Comm_SetDDRAMAddress        =   LCD_HOME_L1;
    const char    DDRAMAddress_Ofst[]         = { LINE1, LINE2, LINE3, LINE4 };

    if ( (x >= charsInLine) || (y >= LINES) )
        return;

    lcd_command( (Comm_SetDDRAMAddress | DDRAMAddress_Ofst[y]) + x );
    lcd_data( c );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::clear( void )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    lcd_command( Comm_ClearDisplay );
    wait( 2e-3 );  // 2e-3  0.002  2ms
    curs[ 0 ]    = 0;
    curs[ 1 ]    = 0;
    curs[ 2 ]    = 0;
    curs[ 3 ]    = 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::contrast( char contrast )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    lcd_command( Comm_FunctionSet_Extended );
    lcd_command( Comm_ContrastSet         |  (contrast     & 0x0f) );
    lcd_command( Comm_PwrIconContrast     | ((contrast>>4) & 0x03) );
    lcd_command( Comm_FunctionSet_Normal   );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::put_custom_char( char c_code, const char *cg, char x, char y )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    for ( int i = 0; i < 5; i++ ) {
        set_CGRAM( c_code, cg );
        putcxy( c_code, x, y );
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::set_CGRAM( char char_code, const char* cg )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    for ( int i = 0; i < 8; i++ ) {
        lcd_command( (Comm_SetCGRAM | (char_code << 3) | i) );
        lcd_data( *cg++ );
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::set_CGRAM( char char_code, char v )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    char    c[ 8 ];

    for ( int i = 0; i < 8; i++ )
        c[ i ]    = v;

    set_CGRAM( char_code, c );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void LCD_COG::clear_rest_of_line( unsigned char line )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    for ( int i = curs[ line ]; i < charsInLine; i++ )
        putcxy( ' ', i, line );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int LCD_COG::lcd_write( char first, char second )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    char cmd[2];

    cmd[ 0 ]    = first;
    cmd[ 1 ]    = second;

    return ( i2c.write( SLAVEADRESS, cmd, 2 ) );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int LCD_COG::lcd_command( char command )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    return ( lcd_write( COMMAND, command ) );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int LCD_COG::lcd_data( char data )
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    return ( lcd_write( DATA, data ) );
}

