
#include "mbed.h"
#include "Dht11.h"
#include "RangeFinder.h"
#include "Grove_LCD_RGB_Backlight.h"

RangeFinder rf(D3, 10, 5800.0, 100000);
DigitalOut led(LED1);
DigitalOut buzzer(D2);
InterruptIn button(D6);
Serial pc(USBTX, USBRX);
Dht11 dhtSensor(D7);

Grove_LCD_RGB_Backlight rgbLCD(I2C_SDA, I2C_SCL);


float temperature = 0.0f;
float humidity = 0.0f;

int on = 1, off = 0;

void flip() 
    {
    buzzer = off;
    }
    
int main()
{
    led = 1;
    float d;
    
    rgbLCD.setRGB(0xff, 0xff, 0xff); 
    char szBuff[10];
    
    button.rise(&flip);  // attach the address of the flip function to the rising edge
    
    
    while(1) {
        dhtSensor.read();
        temperature = dhtSensor.getCelsius();
        humidity = dhtSensor.getHumidity();
        
        printf("Temp: %f, Hum: %f\n", temperature, humidity);
        
        rgbLCD.locate(0,0);
        rgbLCD.print("T:");
        rgbLCD.locate(2,0);
        sprintf(szBuff, "%2.1f", temperature);
        rgbLCD.print(szBuff);
        
        rgbLCD.locate(8,0);
        rgbLCD.print("H:");
        rgbLCD.locate(10,0);
        sprintf(szBuff, "%2.1f", humidity);
        rgbLCD.print(szBuff);
        
        if (temperature >= 25)
            {
                   buzzer = on;
                   wait(5);
                   buzzer = off;  
                   rgbLCD.locate(0,0);
                   rgbLCD.print("T:");
                   rgbLCD.locate(2,0);
                   rgbLCD.print(is over 25);
            }

        wait(1);
        
        
        d = rf.read_m();
        if (d == -1.0)  {
            printf("Timeout Error.\n");   
        } else if (d > 5.0) {  
            // Seeed's sensor has a maximum range of 4m, it returns
            // something like 7m if the ultrasound pulse isn't reflected. 
            printf("No object within detection range.\n");
            rgbLCD.locate(0,1);
            rgbLCD.print("No object");
                    
        } else  {   
                    printf("Detecting object within detection range.\n");
                    rgbLCD.locate(0,1);
                    rgbLCD.print("Detected");
                    printf("Distance = %f m.\n", d);
                    buzzer = on;
                    wait(5);
                    buzzer = off;   
        }
        wait(0.5);
        led = !led;
        
    }
}