#include "mbed.h"
#include "ESP8266.h"               
#include <string>
#include <stdio.h>
// Grove Earbud Sensor include
#include "GroveEarbudSensor.h"

#define APIKEY SQ43V2ERAB2S42I3    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "ATTwXwjd7i"     // Home WIFI ID
#define WIFI_PASS "cmvbfbjrw=+w"   // Home WIFI PASS WORD

Serial pc(USBTX,USBRX);

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

char snd[255],rcv[1000],snd_Data[255];           //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module 

void esp_initialize(void); // Function used to initialize ESP8266 wifi module 
void esp_send(void);       // Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 

// Our sensor as an InterruptIn
InterruptIn sensor(D2);

// callback for receiving heartrate values
void heartrateCallback(float heartrate,void *data) {
    printf("Callback: heartrate = %.1f\r\n",heartrate);
}

// allocate the earbud sensor
GroveEarbudSensor earbud(&sensor); 

float RateofHeart; // Define Global variable for Heatrate detection



DigitalOut heater(A1); // Set DigitalOut port for Alcohol Sensor
AnalogIn Asensor(A0); // Set AnalogIn port for Alcohol Sensor

float value = 0.0f; // Define Global variable for Alcohol detection


int main(void) 
{
    
    pc.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    
    heater = 1;
    
    pc.printf("START\r\n");  // Starting point
    
    esp_initialize();
    
    // register our callback function
    earbud.registerCallback(heartrateCallback);  

    while (1) 
    {   
    
        wait(5);

        esp_send(); //Excute Send function to deliver detected data to Thingspeak website
        
    }
}


void esp_initialize(void) // This is the Initialization function as we defined above.
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    //pc.printf(rcv);          //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);  // Sends command to ESP8266. Receives the command string
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       // Receive reply until no character is received after a given timeout in miliseconds
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);        // Send WIFI Account ID
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);        // Send WIFI Password
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 

}


void esp_send(void) // This is the Initialization function as we defined above.
{
    //Get the rate of Heart by earbud,getHeartRate function
    RateofHeart = earbud.getHeartRate();
    
    //Set the pulse value to 0 to get the data
    heater = 0;
    //Get the value of Alcohol rate sensed by Alcohol sensor
    value = 1-Asensor;
    
    
    
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("S\r\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    pc.printf("Alcohol concentration is: %2.2f\n", value); // Print out the Alcohol concentration on the Tera Term 
    pc.printf("heart rate is: %f\r\n", RateofHeart); // Print out the Heart Rate on the Tera Term 
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=SQ43V2ERAB2S42I3&field1=%f&field2=%f\r\n",RateofHeart);
    //Transfer Heart rate and Alcohol concentration to designated Thingspeak ID and display on field 1 chart and field 2 chart
    
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
    esp.SendCMD(snd);                                                      //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
}