#include "mbed.h"
#include "GPS.h"
#include "LinearTempSensor.h"
#define updateinterval  900

DigitalOut LED_0 (PB_6);
DigitalOut LED_1 (PA_7);
DigitalOut LED_2 (PA_6);
DigitalOut LED_3 (PA_5);
InterruptIn SW1(PB_10);
InterruptIn SW2(PA_8);

Ticker hartbeat;
Ticker position_update;

//Virtual serial port over USB
Serial pc(USBTX, USBRX);
Serial modem(PA_9, PA_10);
GPS gps(PA_9, PA_10);

/*Temperature sensor */
LinearTempSensor sensor(PA_0, 10);
signed char      temperature;         // Temperature in signed char.


void sertmout();
bool modem_command_check_ok(char * command);
void modem_setup();

uint32_t txtimeout = 0;

bool ser_timeout = false;


// Blinking LED Ticker
void beat()
{
    LED_0 = !LED_0;
    txtimeout++;
}

void sw1interrupt()
{
    txtimeout = updateinterval+1; // instantly send
}

void sw2interrupt()
{
    txtimeout = updateinterval+1; // instantly send
}

int main()
{
    wait(3);
    modem_setup();
    float vOut = sensor.Sense();
    pc.printf("\n\rMCP9700 reading:  Vout: %.2f mV\n\r", vOut);
    LED_0 = 1;
    LED_1 = 1;
    LED_2 = 1;
    LED_3 = 1;
    hartbeat.attach(&beat, 1);
    SW2.fall(&sw1interrupt);
    SW1.fall(&sw2interrupt);
    while(!modem_command_check_ok("AT$GPS=1,16,0,65535,1,1\n")) pc.printf("Trying to start GPS...\r\n");
    pc.printf("GPS started!\r\n");
    while(1) {
        if(pc.readable()) {
            if (pc.getc() == 'a')
                modem_command_check_ok("AT$GSND\n");
        }
        int result = gps.sample();
        if(result != NO_LOCK) {
            if((result == RMC && gps.gprmc_status == 'A')) {
                if(txtimeout > updateinterval) {
                    LED_3 = 0;
                    hartbeat.detach();
                    sensor.Sense();
                    temperature = (signed char)rint(sensor.GetAverageTemp());
                    pc.printf("\r\nGPRMC Fix: latitude: %f, longitude: %f Temperature: %d\r\n",gps.get_dec_latitude(),gps.get_dec_longitude(),temperature);
                    char sfcommand[128];
                    sprintf(sfcommand, "AT$SF=%02x%s,2,0\n", temperature & 0xff,gps.get_nmea_to_td()); // Remark & 0xff needed to limit the value to two bytes!
                    modem_command_check_ok(sfcommand);
                    txtimeout = 0;
                    LED_3 = 1;
                    hartbeat.attach(&beat, 1);
                }
            } else if(txtimeout > updateinterval+5) { // 5 seconds extra in case of no fix (why? -> we're only waiting for GPRMC messages and we may have just skipped one)
                LED_2 = 0;
                hartbeat.detach();
                sensor.Sense();
                temperature = (signed char)rint(sensor.GetAverageTemp());
                pc.printf("\r\nNo GPRMC Fix! (sending 0xffff... as position data) Temperature: %d\r\n",temperature);
                char sfcommand[128];
                sprintf(sfcommand, "AT$SF=%02x01010fffffffffffffffff,2,0\n", temperature & 0xff); // Remark & 0xff needed to limit the value to two bytes!
                modem_command_check_ok(sfcommand);
                txtimeout = 0;
                LED_2 = 1;
                hartbeat.attach(&beat, 1);
            }
        } else if(txtimeout > updateinterval+5) { // 5 seconds extra in case of no fix (why? -> we're only waiting for GPRMC messages and we may have just skipped one)
            LED_2 = 0;
            hartbeat.detach();
            sensor.Sense();
            temperature = (signed char)rint(sensor.GetAverageTemp());
            pc.printf("\r\nNo GPRMC Fix! (sending 0xffff... as position data) Temperature: %d\r\n",temperature);
            char sfcommand[128];
            sprintf(sfcommand, "AT$SF=%02x01010fffffffffffffffff,2,0\n", temperature & 0xff); // Remark & 0xff needed to limit the value to two bytes!
            modem_command_check_ok(sfcommand);
            txtimeout = 0;
            LED_2 = 1;
            hartbeat.attach(&beat, 1);
        }
    }
}

void modem_setup()
{
    /* Reset to factory defaults */
    if(modem_command_check_ok("AT&F")) {
        pc.printf("Factory reset succesfull\r\n");
    } else {
        pc.printf("Factory reset TD120x failed\r\n");
    }
    /* Disable local echo */
    modem.printf("ATE0\n");
    if(modem_command_check_ok("ATE0")) {
        pc.printf("Local echo disabled\r\n");
    }
    /* Write to mem */
    if(modem_command_check_ok("AT&W")) {
        pc.printf("Settings saved!\r\n");
    }
}

/* ISR for serial timeout */
void sertmout()
{
    ser_timeout = true;
}

bool modem_command_check_ok(char * command)
{
    /* first clear serial data buffers */
    while(modem.readable()) modem.getc();
    /* Timeout for response of the modem */
    Timeout tmout;
    ser_timeout = false;
    /* Buffer for incoming data */
    char responsebuffer[6];
    /* Flag to set when we get 'OK' response */
    bool ok = false;
    bool error = false;
    /* Print command to TD120x */
    modem.printf(command);
    /* Newline to activate command */
    modem.printf("\n");
    /* Wait untill serial feedback, max 3 seconds before timeout */
    tmout.attach(&sertmout, 3.0);
    while(!modem.readable()&& ser_timeout == false);
    while(!ok && !ser_timeout && !error) {
        if(modem.readable()) {
            for(int i = 0; i < 5; i++) {
                responsebuffer[i] = responsebuffer[i+1];
            }
            responsebuffer[5] = modem.getc();
            if(responsebuffer[0] == '\r' && responsebuffer[1] == '\n' && responsebuffer[2] == 'O' && responsebuffer[3] == 'K' && responsebuffer[4] == '\r' && responsebuffer[5] == '\n' ) {
                ok = true;
            } else if(responsebuffer[0] == '\r' && responsebuffer[1] == '\n' && responsebuffer[2] == 'E' && responsebuffer[3] == 'R' && responsebuffer[4] == 'R' && responsebuffer[5] == 'O' ) {
                error = true;
            }
        }
    }
    tmout.detach();
    return ok;
}
