#include "mbed.h"
 
DigitalOut LED_0 (PB_6);

//Virtual serial port over USB
Serial pc(USBTX, USBRX);
Serial modem(PA_9, PA_10);

bool once = true;

int main() {
    pc.baud(9600);
    modem.baud(9600);
    char c;
    
    LED_0 = 1;
    
    char responsebuffer[3];
    
    while(1) {   
        if(modem.readable()) {
            pc.putc(modem.getc());
        }
        
        if(pc.readable()) {
            c = pc.getc();
            responsebuffer[0] = responsebuffer[1];
            responsebuffer[1] = responsebuffer[2];
            responsebuffer[2] = c;
                if( once && responsebuffer[0] == 'A' && responsebuffer[1] == 'T' && responsebuffer[2] == 'Z' )
                {
                    LED_0 = 0;
                    wait(3);
                    modem.printf("ATZ\n\rATZ\n\r");
                    wait(0.1);
                    modem.baud(115200);
                    pc.baud(115200);
                    wait(0.1); 
                    once = false;
                }      
            modem.putc(c);
        }
    }
}