#include "mbed.h"
#include "VCNL4010.h"

DigitalOut LED_0 (PB_6);
DigitalOut LED_1 (PA_7);
DigitalOut LED_2 (PA_6);
DigitalOut LED_3 (PA_5);
 
//Virtual serial port over USB
Serial pc(USBTX, USBRX);
Serial modem(PA_9, PA_10);

// configure VCNL4010
VCNL40x0 VCNL40x0_Device (PB_9, PB_8, VCNL40x0_ADDRESS);      // Define SDA, SCL pin and I2C address


int main() {
    
    LED_0 = 1;
    LED_1 = 1;
    LED_2 = 1;
    LED_3 = 1;

    unsigned char ID=0;
    unsigned int  AmbiValue=0;
    
       // print information on screen
    pc.printf("\n\n VCNL4010 Proximity/Ambient Light Sensor");
    pc.printf("\n Read Ambillight on demand in endless loop");

    VCNL40x0_Device.ReadID (&ID);                           // Read VCNL40x0 product ID revision register
    pc.printf("\n\n Product ID Revision Register: %d", ID);

    wait_ms(3000);                                          // wait 3s (only for display)
    
    while(1) { 
        VCNL40x0_Device.ReadAmbiOnDemand (&AmbiValue);      // read ambi value on demand
        pc.printf("Ambient light: %5.0i cts \tIlluminance: %7.2f lx\r", AmbiValue, AmbiValue/4.0);
        if(AmbiValue < 5000) LED_3 = 0;
        else LED_3 = 1;
        if(AmbiValue < 4000) LED_2 = 0;
        else LED_2 = 1;
        if(AmbiValue < 3000) LED_1 = 0;
        else LED_1 = 1;
        if(AmbiValue < 2000) LED_0 = 0;
        else LED_0 = 1;
    }
}