#include "mbed.h"
#include "ColourSensor_H.h"

Ticker detectColour;
Timeout readColour;
Timeout reactivateColour;
Timeout solenoidBackOn;

int main() {
    //printf("Program has started\n\r");
    
    ColourSensor ColourSensor(PTC16, PTC13, PTE20);
    
    // Set call rate of colour detection function
    detectColour.attach(callback(&ColourSensor, &ColourSensor::readIf), 0.5);
    
//    int firstLoop = 1;
    
    while (1) {
        // main program loop
        /*
        if (firstLoop) {
            printf("Main loop has started\n\r");
            firstLoop--;
        }
        */
        
        if (ColourSensor.toggleConst && ColourSensor.toggleA) {
            // Call readColSenWhich after x seconds
            //printf("Toggle A\n\r");
            
            readColour.attach(callback(&ColourSensor, &ColourSensor::readWhich), 0.2);
            
            ColourSensor.toggleA = 0;
        }
        
        if (ColourSensor.toggleConst && ColourSensor.toggleB) {
            // Process colour sensor data
            //printf("Toggle B\n\r");
            
            ColourSensor.process();
            
            if(ColourSensor.flagColour) {
                // If dropped disk
                solenoidBackOn.attach(callback(&ColourSensor, &ColourSensor::solenoidOn), 2.0);
            }
            
            reactivateColour.attach(callback(&ColourSensor, &ColourSensor::makeColourActive), 2.0);
            
            ColourSensor.toggleB = 0;
        }
    }
}
