#include <mbed.h>

/* One enable, forward or backwards, controlling both sides
4 PWM lines, two for each side, one controlling forward speed and one for backward speed for EACH side
driving sequence is pwm off, enable toggle, pwm on */

// motor "enable"
DigitalOut motorEnable(PTC12); // right motor "enable" (1 = forward, 0 = reverse)

// motor PWM controls
PwmOut motorLeftFor(PTA5); // left motors forward speed control (blue wire)
PwmOut motorLeftBack(PTA4); // left motors backward speed control (yellow wire)
PwmOut motorRightBack(PTA12); // right motors backward speed control (white wire)
PwmOut motorRightFor(PTD4); // right motors forward speed control (green wire)
// In order to stop, PWM duty cycle must be = 0
// Enable only controls direction wheels spin
/*
class PwmDir{
    PwmOut motorLeft;
    PwmOut motorRight;
    };
typedef struct objStruct Object;
    

void setDirection(bool direction){
    //set the direction to either forward or backwards
    //needs to set the PWM to 0 before changing the enables
    //direction: 1 is forward 0 is backwards
    motorLeftFor.write(0);
    motorRightFor.write(0);
    motorLeftBack.write(0);
    motorRightBack.write(0);
    
    if(direction){
        motorEnable = true;
        }
    else{
        motorEnable = false;
        }
    
    }*/

void setSpeed(float speed, PwmOut mRight, PwmOut mLeft) {
    // set speed of either forward or backward PWMs
    // set both wheels to same speed
    // NOTE: set enable BEFORE calling function
    // speed: speed to be set
    // mRight & mLeft: pass PwmOut names of relevant Right and Left motor controls
    mRight.write(speed);
    mLeft.write(speed);
}

void setSpeed(float speedRight, float speedLeft, PwmOut mRight, PwmOut mLeft) {
    // set speed of either forward or backward PWMs
    // set each wheel speed independently
    // NOTE: set enable BEFORE calling function
    // speed: speed to be set
    // mRight & mLeft: pass PwmOut names of relevant Right and Left motor controls
    mRight.write(speedRight);
    mLeft.write(speedLeft);
}

void turn(float angle, float speed) {
    // angle: angle of turn, normalised so 1 = 90 degrees (0.5 = 45 degrees right, 0 = straight forward, -0.5 = 45 degrees left)
    // speed: speed of dominant (outside) wheels
    float speedFactor = angle * 20.0; // factor the speed is divided by to get the inside wheel speed
    float speedLess = speed / speedFactor; // speed of non-dominant (inside) wheels
    
    if (angle > 0) {
        // if turning right
        setSpeed(speedLess, speed, motorRightFor, motorLeftFor);
    } else if (angle < 0) {
        // if turning left
        setSpeed(speed, speedLess, motorRightFor, motorLeftFor);
    } else {
        // if no turn
        printf("No. Use setSpeed().");
    }
}

int main() {
    // initial conditions
    motorEnable.write(1);
    motorLeftFor.write(0);
    motorRightFor.write(0);
    motorLeftBack.write(0);
    motorRightBack.write(0);
    
    struct PwmDir PwmFw;
    struct PwmDir PwmBw;
    
    
    float speed;
    float speedRight, speedLeft;
    float angle;
    
    bool direction;
    
    //setSpeed(0.1,
    
    while(1){
        
        
        
    }
}