#include <mbed.h>

/* One enable, forward or backwards controlling both sides
4 PWM lines, two for each side, one controlling forward speed and one for backward speed for EACH side
driving sequence is pwm off, enable toggle, pwm on */

// motor "enable"
DigitalOut motorEnable(PTC12); // right motor "enable" (1 = forward, 0 = reverse)

// motor PWM controls
PwmOut motorLeftFor(PTA5); // left motors forward speed control (blue wire)
PwmOut motorLeftBack(PTA4); // left motors backward speed control (yellow wire)
PwmOut motorRightBack(PTA12); // right motors backward speed control (white wire)
PwmOut motorRightFor(PTD4); // right motors forward speed control (green wire)
// In order to stop, PWM duty cycle must be = 0
// Enable only controls direction wheels spin

int brakeUsed = 0;

void speedChange(float speedFinal, float speedInit, int dirFinal, int dirInit, float rate) {
    // change to desired speed
    // speedFinal: desired final speed (range 0 to 1)
    // speedInit: speed at time of function call (range 0 to 1)
    // dirFinal: final direction: forward = 1, reverse = 0
    // dirInit: direction at function call: forward = 1, reverse = 0
    // rate: rate of change per loop (technical range -1 to 1, recommended range -0.01 to 0.01)
    // set rate = 1 for instant change
    
    float i; // for loop variable
    
    if (dirFinal && dirInit) {
        // if going forward to forward
        if (speedFinal > speedInit) {
            // if speeding up
            if (rate == 1) {rate = speedFinal - speedInit;}
            for (i = speedInit; i <= speedFinal; i += rate) {
                // increase speed from initial to final value
                motorRightFor.write(i);
                motorLeftFor.write(i);
                wait(0.001);
            }
        } else if (speedFinal < speedInit) {
            // if slowing down
            if (rate == 1) {rate = speedInit - speedFinal;}
            for (i = speedInit; i >= speedFinal; i -= rate) {
                // decrease speed from initial to final value
                motorRightFor.write(i);
                motorLeftFor.write(i);
                wait(0.001);
            }
        } else {
            printf("Error: initial and final speeds are equal");
        }
        
    } else if (dirFinal && !dirInit) {
        // if from reverse to forward
        // reduce speed to 0, change enable polarity, increase speed to final value
        
        if (rate == 1) {rate = speedInit;}
        for (i = speedInit; i >= 0; i -= rate) {
            // decrease speed to 0
            motorRightBack.write(i);
            motorLeftBack.write(i);
            wait(0.001);
        }
        // change motor enable polarity
        motorEnable.write(!motorEnable.read());
        
        if (rate == 1) {rate = speedFinal;}
        for (i = 0; i <= speedFinal; i += rate) {
            // increase speed to final value
            motorRightFor.write(i);
            motorLeftFor.write(i);
            wait(0.001);
        }
    } else if (!dirFinal && dirInit) {
        // if from forward to reverse
        // reduce speed to 0, change enable polarity, increase speed to final value
        
        if (rate == 1) {rate = speedInit;}
        for (i = speedInit; i >= 0; i -= rate) {
            // decrease speed to 0
            motorRightFor.write(i);
            motorLeftFor.write(i);
            wait(0.001);
        }
        // change motor enable polarity
        motorEnable.write(!motorEnable.read());
        
        if (rate == 1) {rate = speedFinal;}
        for (i = 0; i <= speedFinal; i += rate) {
            // increase speed to final value
            motorRightBack.write(i);
            motorLeftBack.write(i);
            wait(0.001);
        }
    } else if (!dirFinal && !dirInit) {
        // if from reverse to reverse
        if (speedFinal > speedInit) {
            // if speeding up
            if (rate == 1) {rate = speedFinal - speedInit;}
            for (i = speedInit; i <= speedFinal; i += rate) {
                motorRightBack.write(i);
                motorLeftBack.write(i);
                wait(0.001);
            }
        } else if (speedFinal < speedInit) {
            // if slowing down
            if (rate == 1) {rate = speedInit - speedFinal;}
            for (i = speedInit; i >= speedFinal; i -= rate) {
                motorRightBack.write(i);
                motorLeftBack.write(i);
                wait(0.001);
            }
        } else {
            printf("Error: initial and final speeds are equal");
        }
    } else {
        printf("Well, somehow you've broken this. Congratulations, have a biscuit.");
    }
}

void turnRight(float speed) {
    motorRightFor.write(0);
    motorLeftFor.write(speed);
}

void turnLeft(float speed) {
    motorRightFor.write(speed);
    motorLeftFor.write(0);
}

void turnNone(float speed) {
    motorRightFor.write(speed);
    motorLeftFor.write(speed);
}

void stop() {
    // stop motors
    // sets all motor speeds to 0
    
    motorRightFor.write(0);
    motorLeftFor.write(0);
    motorRightBack.write(0);
    motorLeftBack.write(0);
}    
    

int main() {
    // speed and control variables
    float speed = 0.3; // maximum speed (range 0 to 1), recommend no higher than 0.7
    float accelRate = 0.0001; // amount wheel speed changes each time through speedChange for loop
    
    // set initial conditions
    motorEnable.write(1);
    motorRightFor.write(0);
    motorLeftFor.write(0);
    motorRightBack.write(0);
    motorLeftBack.write(0);
        
    while(1) {
        speedChange(speed/2, 0, 1, 1, accelRate);
        wait(1);
        turnRight(speed/2);
        wait(2);
        turnLeft(speed/2);
        wait(4);
        turnRight(speed/2);
        wait(2);
        turnNone(speed/2);
        wait(1);
        speedChange(speed, speed/2, 1, 1, accelRate);
        wait(2);
        speedChange(speed, speed, 0, 1, accelRate);
        wait(4);
        stop();
        wait(3);
    }
}