// ColourSensor_H.h

#ifndef ColourSensor_H
#define ColourSensor_H

#include "mbed.h"

// ColourSensor is used to detect the coloured disks and control the Solenoid
/* Attributes:
    - Pinouts of sensor inputs and solenoid output

   Methods:
    - solenoidSet
    - readColSenIf
    - readColSenWhich
    - colourCheck
    - makeColourActive
*/

class ColourSensor {
    public:
        void solenoidSet(bool state); // Setting solenoid state
        void readIf(); // Read 'IF' sensor
        void readWhich(); // Read 'WHICH' sensor
        void process(); // Colour processing
        void initialConditions(); // Sets initial conditions
        
        DigitalIn inIf;
        DigitalIn inWhich;
        DigitalOut solenoid;
        
        int firstLoop;
        bool toggleA;
        bool toggleB;
        bool toggleConst; // Can be used to toggle colour processing
        
        ColourSensor(PinName pin1, PinName pin2, PinName pin3);
        
        void makeColourActive();
        
        
    private:
        bool detectedIf; // Colour detected? Yes/No -> 1/0
        bool detectedIfOld; // Comparison bool
        bool newDetection; // Colour newly detected? (i.e. is now but wasn't before?) Yes/No -> 1/0
        bool detectedWhich; // Colour detected: Red/Blue -> 1/0
        bool diskHave; // Have disk? Yes/No -> 1/0
        bool diskColour; // Colour of disk: Red/Blue -> 1/0
        
        bool solenoidState; // State of solenoid: On/Off -> 1/0
        
};

#endif