#ifndef TSIHW_H
#define TSIHW_H

#include "mbed.h"
/**
* KL25 TSI low-level library with very basic functions
*
* @code
* #include "mbed.h"
* #include "TSIHW.h"
* 
* TSI touch(0,0,0,2,2);
* Serial pc(USBTX, USBRX);
* 
* int main() {
*     uint16_t s;
*     
*     pc.printf("BEGIN\r\n");
*     touch.ActivateChannel(5); // Electrode connected to PTA4
*     pc.printf("ACTIVATE\r\n");
*     while(1) {
*         s = 0;
*         touch.Start(5);
*         pc.printf("START\r\n");
*         while(!s) {
*             s = touch.Read();
*         }
*         pc.printf("TOUCH: %d\r\n", s);
*         wait(1);
*     }
* }
* @endcode
*/


class TSI
{
public:
  TSI(char rchg, char echg, char dvolt, char ps, char nscn);

  ~TSI();

  void ActivateChannel(char ch);
  
  void Start(char ch);
  
  uint16_t Read(void);
  
};
#endif
