#include "mbed.h"
#include "MMA8451Q.h"

// Defines for sensors I2C
#define SDA     PTE25
#define SCL     PTE24
#define INT1    PTA14

// Define for LED
#define  LRED   PTC7

MMA8451Q acc(SDA, SCL);
Serial pc(USBTX, USBRX);
Ticker t; // Periodical timer for reading sensors
//InterruptIn drdy(INT1);
DigitalOut myled(LRED);

void newdata() {
    int16_t accdata[3];
    
    myled = !myled;
    // Reads all accelerometer and magnetometer data, and also reads analog from FSR1 and FSR2
    acc.getAccAllAxis(accdata);
    // Now we transmit data
    pc.printf("%d,%d,%d\r\n", accdata[0], accdata[1], accdata[2]);
}

int main() {
    char cmd;
    myled = 1;
    pc.baud(921600); // 176kbps ou mais
    //drdy.disable_irq();
    //drdy.fall(&newdata);
    
    while(1) {
            if(pc.readable()) {
            cmd = pc.getc();
            if(cmd == '1') {
                t.attach(&newdata, 0.00125); //  800Hz samples
                //drdy.enable_irq();
            } else if(cmd == '0') {
                t.detach();
                //drdy.disable_irq();
                myled = 1;
            } 
        }
    }
}

/*

        */