#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "stdlib.h"


void Terrain(int xg, int yg, int xd, int yd, int x1, int y1);


int main() {  

    //Manette gauche
    DigitalIn d0(D0);
    DigitalIn d2(D2);
    //Manette Droite
    DigitalIn d5(D5);
    DigitalIn d7(D7);
    
    TS_StateTypeDef TS_State;
    uint8_t status;
    int TouchScreen=1;
    int x1=240, y1=136, depx=2, depy=2;
    int xg=0, yg=96, xd=474, yd=96;
    int direcx=1, direcy=1;

    srand(time(NULL));
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"PONG!!", CENTER_MODE);
    HAL_Delay(2000);
    
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Start ?", CENTER_MODE);
    HAL_Delay(500);
    
    //Attente avant de toucher l'écran
    while(TouchScreen){
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            TouchScreen = 0;
        }
    }
    TouchScreen=1;
    
    //départ alétoire de la balle
    direcx = rand() % (50+1);
    if (direcx ==0%2) {depx=-depx;}
    direcy = rand() % (50+1);
    if (direcy ==0%2) {depy=-depy;}
    
    Terrain(xg, yg, xd, yd, x1, y1);
    HAL_Delay(500);
    
    while(1){
        
        //Déplacement haut de la raquette gauche
        if(d0==1 && yg>=15) yg-=5;
        //Déplacement bas de la raquette gauche
        else if(d2==1 && yg<=200) yg+=5;
        
        //Déplacement haut de la raquette droite
        if(d7==1 && yd>=15) yd-=5;
        //Déplacement bas de la raquette droite
        else if(d5==1 && yd<=200) yd+=5;
        
        //Limite basse
        if(y1>=264) {
            depy=-depy;
        }
        
        //Limite haute
        else if(y1<=6) {
            depy=-depy;
        }
        
        //Limite droite
        else if(x1>=470) {
            //Si on touche la raquette
            if (BSP_LCD_ReadPixel(x1+7, y1)==0xFFFFFFFF) {
                //Accélération de la balle
                if (depx>0 && depx<5) depx+=1;
                else if (depx<0 && depx>-5) depx-=1;
                depx=-depx;
                }
                //Si on touche le bord
            else if (BSP_LCD_ReadPixel(x1+7, y1)==0xFF000000){
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Rejouer ?", CENTER_MODE);
                HAL_Delay(1000);
                
                while(TouchScreen){
                    BSP_TS_GetState(&TS_State);
                    if (TS_State.touchDetected) {
                        TouchScreen = 0;
                        }
                    }
                    TouchScreen=1;
                    
                //Ré-initialisation
                x1=240;
                y1=136;
                xg=0;
                yg=96;
                xd=474;
                yd=96;
                depx=2;
                depy=2;
                
                //Départ aléatoire
                direcx = rand() % (50+1);
                if (direcx ==1%2) {depx=-depx;}
                direcy = rand() % (50+1);
                if (direcy ==1%2) {depy=-depy;}
                
                BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                Terrain(xg, yg, xd, yd, x1, y1);
                HAL_Delay(500);
                }
        }
        
        //Limite gauche
        else if(x1<=10) {
            //Si on touche la raquette
            if (BSP_LCD_ReadPixel(x1-7, y1)==0xFFFFFFFF) {
                //Accélération de la balle
                if (depx>0 && depx<5) depx+=1;
                else if (depx<0 && depx>-5) depx-=1;
                depx=-depx;
                }
            //Si on touche le bord
            else if (BSP_LCD_ReadPixel(x1-7, y1)==0xFF000000) {
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Rejouer ?", CENTER_MODE);
                HAL_Delay(1000);
                
                while(TouchScreen){
                    BSP_TS_GetState(&TS_State);
                    if (TS_State.touchDetected) {
                    TouchScreen = 0;
                        }
                    }
                TouchScreen=1;
                
                //Ré-initialisation 
                x1=240;
                y1=136;
                xg=0;
                yg=96;
                xd=474;
                yd=96;
                depx=2;
                depy=2;
                
                //Départ aléatoire
                direcx = rand() % (50+1);
                if (direcx ==1%2) {depx=-depx;}
                direcy = rand() % (50+1);
                if (direcy ==1%2) {depy=-depy;}
                
                BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                Terrain(xg, yg, xd, yd, x1, y1);
                HAL_Delay(500);     
                }
        }
        x1+=depx;
        y1+=depy;
        Terrain(xg, yg, xd, yd, x1, y1);
    }
}

void Terrain(int xg, int yg, int xd, int yd, int x1, int y1) {
    //Affichage de...
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    //Raquettes
    BSP_LCD_FillRect(xg, yg, 6, 80);
    BSP_LCD_FillRect(xd, yd, 6, 80);
    //Filet
    BSP_LCD_FillRect(239, 0, 3, 271);
    //Balle
    BSP_LCD_FillCircle(x1, y1, 6);
    HAL_Delay(15);
    }
    