//BAUMER GXMMW Absolute Multiturn encoder example code
//Steps per turn ≤8192 / 13 bit
//Number of turns ≤65536 / 16 bit

//Reading BAUMER GXMMW encoder data bypasing CANopen interface
//Reading 29bit (multiturn) position from Absolute encoder via SSI
//Displaying encoder positon on i2c OLED 32x128 display

#include "mbed.h"
#include "Adafruit_SSD1306.h"

DigitalOut myled(LED1);

SPI spi(p5, p6, p7); //I'm using only pin p6 & p7 for encoder->mbed connection

I2C myI2C(p9,p10);  //OLED screen
Adafruit_SSD1306_I2c oled(myI2C,p13,0x78,32,128);
 
int main(){
    spi.format(10,2);
    spi.frequency(500000);
    
    Serial pc(USBTX, USBRX);
    
    uint32_t data[3] = {0, 0, 0};
    uint32_t encoder_value = 0;
    
    while(1)
    {   
        //clocking out 30bit of data from encoder
        data[0] = spi.write(0xFF);
        data[1] = spi.write(0xFF);
        data[2] = spi.write(0xFF);

        data[0] <<= 20;
        data[1] <<= 10;
    
        encoder_value = data[2] | data[1] | data[0];
        
        encoder_value &= 0x1FFFFFFF; // masking first bit (30bit->29bit)
        
        //displaying encoder data on serial monitor
        //pc.printf("%d\n",encoder_value);
    
        oled.printf("%09u\r",encoder_value);
        oled.display();
        
        wait_us(50);
    }
}