#include"MicroBit.h"

MicroBit uBit;

int main()
{
    uBit.init();
    //listen for stinger signal  E5E5
    ManagedString sting=" E5E5";
    ManagedString readbuf=uBit.serial.read(5);
    if (readbuf==sting)
        {
            //Identify to inputattach driver
            uBit.serial.send("\r\n0600520058C272");
            uBit.display.scroll("Stinger");
            int x,y;
            unsigned char data[4];
            while(1)
                {
                    //packets [0 && 3] deal with buttons
                    //packet [0,1,2] deal with joystick
                    x=((uBit.accelerometer.getPitch()+180)*126/360);
                    y=((uBit.accelerometer.getRoll()+180)*126/360);
                    data[1]=0x3f-(x & 0x3f);
                    data[2]=y & 0x3f;
                    data[0]=((y & 0x40)>>5)+((x & 0x40)>>6);
        
                    if (uBit.buttonA.isPressed()){data[0]+=0x20;}
                    if (uBit.buttonB.isPressed()){data[0]+=0x10;}
                    //send packet
                    for (int i=0;i<4;i++){uBit.serial.sendChar(data[i]);}
                }
        }
    return 0;
}
