#include"MicroBit.h"
//#define ARQ_DEBUG

#define ARQ_ID              4000
#define ARQ_MSG_RECVD_EVT   1
#define ARQ_MSG_SEND_FAIL   2
#define ARQ_MSG_ACK_RECVD   3
#define ARQ_POW_RECVD_EVT   4
#define ARQ_POW_SEND_FAIL   5
#define ARQ_POW_ACK_RECVD   6

#ifndef ARQ_H
#define ARQ_H

class Arq
{
    public:
    unsigned char power;    //power of transmitter
    unsigned char received_power;
    unsigned int timeout;   //time after send with no ACK before resend in microseconds CURRENTLY IRRELEVANT!! 
    unsigned int maxtries;  //max number of attempts at sending before give up :( (default 10)
    unsigned int mintries;  //min number of attempts allowable (default 1)
    unsigned int tries;     //number of attempts at last go
    unsigned int rssi;      //rssi from last ACK received i.e. rssi reported by receiver
    unsigned int min_rssi;  //rssi below which power can be reduced (default 70)

    MicroBit *uBit;
    PacketBuffer packet;
    
    Arq(MicroBit *bit);
    ~Arq(){};
    
    void off();
    void receive();
    void listen(MicroBitEvent e);
    void send(PacketBuffer packet);

    void incPower();
    void decPower();
};

#endif

//1st byte ACK,POWER_TEST or MESSAGE if ACK, RSSI of RECEIVED MESSAGE ALSO
//128   64   32   16   8   4   2   1
//  1    1    1    0   0   0   0   0  - ACK  -98 RSSI
//  1    0    1    1   0   0   0   1  - ACK  -49 RSSI
//  0    0    0    0   0   0   0   0  - POWER_TEST
//  0    1    1    1   1   1   1   1  - MESSAGE

//if POWER_TEST 2nd byte is power
//if MESSAGE 2nd byte is start of message packet[1]

 