 //This code is for 8Vpp or amplitude of 4V when connected to mbed 
 
#include "mbed.h"
#include "C12832_lcd.h"
#include <complex>
#include "Servo.h"

C12832_LCD lcd;
AnalogIn   VIN(A2);
Servo s1(p22); 
Servo s2(p23);
Serial pc(USBTX, USBRX); // see how to use this to print off to PC

float y;
float f;
int counter = 1;
Timer t;

int main() 
{                       //open1
    lcd.printf("STARTING! \n") ;
    while(1)            //Repeat process loop
    {                   //open2
        counter = 1;    // resets counter back to 1 every time frequency has been read
        t.reset();      // reset timer every time the frequency has been read out
        while   (counter < 22)           // while loop counts for 21 hits on peak point 
        {               //open3
            float V =  3.2 * VIN.read(); // Converting the Voltage input to a higher decimal for more accurate readings. Check if needed by dividing the next if statement by 3.2...
            if( V >= 0.9&& V <= 1.1)     // Checks when the voltage on the sinusoidal input is at a given range to measure time taken for certain amount of hitpoints to calculate frequency... 
            {           //open4
            lcd.printf("V = %2.4f Counter is : %d \n", V, counter) ; // just a checking for myself to ensure counter is working, Will be taken out because unnecessary reading...
            if (counter == 1) //when counter is equal to 1 and the previous if statement is correct then will start the timer once, until counter is < 21
                {       //open5
                t.start();
                }       //close5
            counter++;                   // adds to counter 1, everytime the while loop has been gone through
            }           //close4 
        }               //close3
    t.stop();                            // Timer stops when the counter loop is finished
    y = t.read()/10.01 ;             // averaging the time it has taken to take      
    f = ((1/y)+0.013);
        lcd.cls();
       //lcd.printf("time taken is : %3.4f sec \n", t.read()) ; 
       lcd.printf(" %3.3f Hz \n", f) ;   // print frequency reading to 3 decimal places 
 
s1 = ((1*f)- 49.5) ;
s2 = ((1*f)- 49.45);
//s2 = 0.5;
      // No need for this when printing off on computer screen 
        pc.printf("$%d %d;", f, y);      // SEE HOW TO USE THIS TO PRINT OFF FREQUENCY READING TO PC
       wait_ms(2000); 
    }                   //close2
}                       //close1