#include "mbed.h" // Library

#define STEER_PERIOD 59 // Define the PWM period
#define DRIVE_PERIOD 59 // Define PWN PERIOD
#define Drive_DUTY_CYCLE 0.6 // drive duty cycle set to 70%(constant speed)

AnalogIn RightSensor(p17); // sensor input (Brown)
AnalogIn LeftSensor(p18); // sensor input (grey)
AnalogIn feedback(p19); // potentiometer input
PwmOut Steer(p23); // pwm output
PwmOut Drive(p21); // pwm output

float Gain1 = 2; // steering control proportional gain
float Gain2 = 1.5; // steering control proportional gain 
float setpoint = 0.0; 
double Position =0.0; // to calculate the relative positions from the sensors
float e = 0.0;

int main()
{
Drive.period_us(STEER_PERIOD); // setting pwm frequency to 20 kHZ
Steer.period_us(DRIVE_PERIOD); // setting pwm frequency to 20 kHZ
Drive = Drive_DUTY_CYCLE; // sending out pwm of 75%
Steer = 0.5;//set initial duty cycle to 50% 

while(1){
 
Position = LeftSensor - RightSensor; // taking difference to provide singular value
setpoint = 0.5 + Gain1*Position;  // set point defined by sesnor inputs
if(setpoint > 0.7) setpoint = 0.7; // pot feedback

else if(setpoint < 0.42) setpoint = 0.42; // pot feedback

e = setpoint - feedback; // calculating the error in position
Steer = 0.5 + (Gain2*e); // basic proportional of steering
}
}

