/**
@Project A Weather Station
@Measure the current environment temperature and pressure
@file main.cpp
@brief header file containing function prototypes, defines and global variables
@auther Kun Qian
@data 07/05/2015
*/


#include "mbed.h"
#include "BMP180.h"
#include "N5110.h"

/**
@namespace lcd
@namespace BMP180
@namespace mbed
*/


N5110 lcd(p7,p8,p9,p10,p11,p13,p26);//The ports  being connected of the mbed
BusOut leds(LED4,LED3,LED2,LED1);//The ports  being connected of the LCD
BMP180 bmp180(p28,p27);//The ports being connected to the sensor
Serial serial(USBTX,USBRX);//Timer set-up tool

/**
Define the variable will be used in the programming
*/

void serialISR();//ISR that is called when serial data is received
void setTime();// function to set the UNIX time
int setTimerFlag = 0;// flag for ISR
char rxString[16];//Create a 16 chars row to display the data

/**
Set up a project title before the data shows on the LCD
*/
int main()
{
    lcd.init();
    bmp180.init();//Display the word before the sensor data
    lcd.printString("Weather",0,0);//At the location (0,0),display word "Weather"
    lcd.printString("Station",1,3);//At the location (1,3),display word "Station"
    wait(2.0);//The word above stay for 2s
    lcd.clear();//Clean the display for the continued work

    /**
    Start the measuremrnt progressing
    */
    Measurement measurement;

    serial.attach(&serialISR);//attach serial ISR
    char t[30];//Create a 30 chars row to display the time

    /**
    Create the row for the timer and ensure the location of it
    */
    while(1) {

        time_t seconds = time(NULL);//get current time
        // format time into a string (time and date)
        strftime(t, 30 , "%X %D",localtime(&seconds));//
        // print over serial
        serial.printf("Time = %s\n" ,t);//Display the timer
        lcd.printString(t,0,5);//The location of the timer

        if(setTimerFlag) {// if updated time has been sent
            setTimerFlag = 0;//clear flag
            setTime();// update time

        }

        /**
        Display the data measure by the sensor and show on the LCD
        Enbsure the form and location of it
        */
        measurement = bmp180.readValues();//
        char T[14];//Create a 14 chars row to display the temperature
        int length =sprintf(T,"T = %.2f C",measurement.temperature);//Set up "T = sensor data" as the thing will be shown
        if (length <= 14)//Judge the length of chars
            lcd.printString(T,0,1);//The location of the T will be shown
        char P[14];//Create a 14 chars row to display the pressure
        length = sprintf(P,"P = %.2f mb",measurement.pressure);//Set up "P = sensor data" as the thing will be shown
        lcd.printString(P,0,3); //The location of the P will be shown
        wait(1);//Repeat the circulate each 1s
        lcd.clear();  //Clear the data for next processing
    }
}

/**
Create a string to the interge and set the current time
*/
void setTime()//// print time for debugging
{

    serial.printf("set_time - %s",rxString);
    //// atoi() converts a string to an integer
    int time = atoi(rxString);
    //update the time
    set_time(time);
}
/**
When the serial interrupt occurs, read rs string either
*/
void serialISR()// when a serial interrupt occurs, read rx string into buffer
{

    serial.gets(rxString,16);
    //// set flag
    setTimerFlag = 1;
}
