#include "stm32f103c8t6.h"
#include "mbed.h"
#include "WebUSBDFU.h"

DigitalOut  myled(LED1);

bool detached = false;
void onDetachRequested() {
    detached = true;
}

void resetIntoBootloader() {
    // Turn on write access to the backup registers
    __PWR_CLK_ENABLE();
    HAL_PWR_EnableBkUpAccess();

    // Write the magic value to force the bootloader to run
    BKP->DR2 = 0x544F;
    BKP->DR1 = 0x4F42;

    HAL_PWR_DisableBkUpAccess();

    // Reset and let the bootloader run
    NVIC_SystemReset();
}

int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)

    /* Note: 1209:0001 is a test VID/PID pair - it should be changed before using in
     * a real application */
    WebUSBDFU usbDFU(0x1209, 0x0001, 0x0001, false);
    usbDFU.attach(onDetachRequested);

    while(1) {
        // Check the DFU status
        if (!usbDFU.configured()) {
            usbDFU.connect(false);
        }
        if (detached) {
            for (int i=0; i < 3; i++) {
                myled = 1;
                wait_ms(100);
                myled = 0;
                wait_ms(100);
            }
            resetIntoBootloader();
        }

        // Do normal stuff
        myled = !myled;
        wait_ms(500);
    }
}

