#include "mbed.h"
#include "max86150.h"
#include "i2c_functions.h"

DigitalOut myled(P7_1);
Serial myPC(USBTX, USBRX);   // Initiating Serial Console communication
void device_data_read(void);

    
int main()
{
    int i=0, j=0;

    i2c_freq(100000);
    myPC.baud(57600);

    while (i++<1) {
        myled = !myled;
        wait(1);

        char data_read[9];
        char data_write[2];

        // enable()
        data_write[0] = 0x01;
        i2c_write(0xBC, 0x0D, data_write,1);    // reset        
        data_write[0] = 0x0C;
        i2c_write(0xBC, 0x08, data_write,1);    // FIFO roll ON
        data_write[0] = 0x21;
        i2c_write(0xBC, 0x09, data_write,1);    // FDx
        data_write[0] = 0x09;
        i2c_write(0xBC, 0x0A, data_write,1);    // FD3=ECG
        data_write[0] = 0xDB;
        i2c_write(0xBC, 0x0E, data_write,1);    // PPG_ADC_RANGE PPG_SR:100SpS, PPG_LED_PW:400uS
        data_write[0] = 0x10;
        i2c_write(0xBC, 0x11, data_write,1);    //LED current - IR
        data_write[0] = 0x55;
        i2c_write(0xBC, 0x12, data_write,1);    //LED current - Red
        data_write[0] = 0x10;
        i2c_write(0xBC, 0x15, data_write,1);    //Pilot_PA   
        data_write[0] = 0x04;
        i2c_write(0xBC, 0x10, data_write,1);    //PROX_INT_THRESH    
        
        data_write[0] = 0x03;
        i2c_write(0xBC, 0x3C, data_write,1);    //ECG SAMPLE RATE    
        data_write[0] = 0x0D;
        i2c_write(0xBC, 0x3E, data_write,1);    //PGA_ECG_GAIN, IA_GAIN    
          
        //data_write[0] = 0x40;
        //i2c_write(0xBC, 0x02, data_write,1);    //PPG_RDY_EN  
           
        data_write[0] = 0x10;
        i2c_write(0xBC, 0x02, data_write,1);    //[4] PROX_INT_EN   
        data_write[0] = 0x04;
        i2c_write(0xBC, 0x03, data_write,1);    //ECG_RDY_INT_EN    
        data_write[0] = 0x04;
        i2c_write(0xBC, 0x0D, data_write,1);    //FIFO start

        myPC.printf("\r\nStart reading...");
        while (j++<15) {
            myPC.printf("\r\n#%d, ", j);
            
            i2c_read(0xBC, 0x00, data_read, 2);
            while(data_read[0]==0x00 & data_read[1]==0x00) {  
                myPC.printf("\r\nReg 0x00 = 0x%x, Reg 0x01 = 0x%x, wait for INT", data_read[0], data_read[1]);   
                i2c_read(0xBC, 0x00, data_read, 2);            
            }    
            if (data_read[0] == 0x80) { // FIFO almost full
                myPC.printf("\r\nReg 0x00 = 0x%x, read data", data_read[0]);
                device_data_read();
            }else if(data_read[1]&0x04 == 0x04) {  // Power Ready
                myPC.printf("\r\nReg 0x00 = 0x%x, read data", data_read[1]);
                device_data_read(); 
            }else if(data_read[0] == 0x10) {  // Prox_INT
                myPC.printf("\r\nReg 0x00 = 0x%x, Proximity Interrupt", data_read[0]);
                data_write[0] = 0x00;
                i2c_write(0xBC, 0x0D, data_write,1);
                data_write[0] = 0x04;
                i2c_write(0xBC, 0x0D, data_write,1);   
                data_write[0] = 0x80;
                i2c_write(0xBC, 0x02, data_write,1); 
            }else if(data_read[0] == 0x01) {  // Power Ready
                myPC.printf("\r\nReg 0x00 = 0x%x, Power Ready", data_read[0]); 
            }else
                myPC.printf("\r\nReg 0x00 = 0x%x, Reg 0x01 = 0x%x, other INT event...", data_read[0], data_read[1]);   
        }
    }
}

void device_data_read(void)
{
    char wr_ptr;
    char rd_ptr;
    char prox_int_threshold;
    char flag = 0;
    char dataBuff[32*3*3];
    int sampleCnt = 0;
    int red[32], ir[32], ecg[32], threshold_lower;
    int i;
    
    i2c_read(0xBC, 0x04, &wr_ptr, 1);
    i2c_read(0xBC, 0x06, &rd_ptr, 1);
    
    if(wr_ptr > rd_ptr)
        sampleCnt = wr_ptr - rd_ptr;
    else
        sampleCnt = 32 + wr_ptr - rd_ptr;
    i2c_read(0xBC, 0x07, dataBuff, sampleCnt*2*3);
    
    i2c_read(0xBC, 0x10, &prox_int_threshold, 1);
    threshold_lower = prox_int_threshold*2048*0.8;
    
    for(i=0;i<sampleCnt;i++){
        ir[i] = ((dataBuff[i*6+0] << 16) + (dataBuff[i*6+1] << 8) + dataBuff[i*6+2]) & 0x7ffff;        
        red[i] = ((dataBuff[i*6+3] << 16) + (dataBuff[i*6+4] << 8) + dataBuff[i*6+5]) & 0x7ffff;
        ecg[i] = ((dataBuff[i*6+6] << 16) + (dataBuff[i*6+7] << 8) + dataBuff[i*6+8]) & 0x7ffff;        
        // check sign bit
        if(ecg[i]>0x1FFFF)
                    ecg[i] = -((~ecg[i] + 1) & 0x1FFFF);
                else
                    ecg[i] = ecg[i];        
        myPC.printf("\r\nIR = %d, RED = %d, ECG = %d", ir[i], red[i], ecg[i]);
        if(ir[i]<threshold_lower){
            flag = 0x10;    // PROX_ON    
            myPC.printf("\r\nIR = %d Enter PROX mode", ir[i]);
        }
    }
    if(flag!=0)
        i2c_write(0xBC, 0x02, &flag,1);    // PROX_INT_EN
}  