#include "mbed.h"
#include "AVRISP.h"

#define FUSE_LOW            0xD0
#define FUSE_HIGH           0xD9
#define FUSE_EXTENDED       0xFF
#define LOCK_BYTE           0xFF

LocalFileSystem local("local");
AVRISP avrisp(p11,p12,p13,p14);
Serial pc(USBTX, USBRX);

int main()
{
    bool ifSuccessful;
    
    pc.printf("Press any button to program the AVR.\n");
    char c = pc.getc();
    
    ifSuccessful = avrisp.EnableProgrammingMode();
    if(ifSuccessful)
    {
        pc.printf("Enter Programming Mode: Successful.\n");
    }
    else
    {
        pc.printf("Enter Programming Mode: Failed.\n");
    }
    
    int signatureByte1 = avrisp.ReadChipSignatureByte1();
    int signatureByte2 = avrisp.ReadChipSignatureByte2();
    int signatureByte3 = avrisp.ReadChipSignatureByte3();
    pc.printf("Chip signature is %x %x %x\n",signatureByte1,signatureByte2,signatureByte3);
    
    pc.printf("Erase Chip.\n");
    avrisp.ChipErase();
    
    pc.printf("Write Fuse Low Byte.\n");
    avrisp.WriteFuseLow(FUSE_LOW);
    pc.printf("Fuse Low Byte Readback = %x.\n",avrisp.ReadFuseLow());
    
    pc.printf("Write Fuse High Byte.\n");
    avrisp.WriteFuseLow(FUSE_HIGH);
    pc.printf("Fuse High Byte Readback = %x.\n",avrisp.ReadFuseHigh());
    
    pc.printf("Write Fuse Extended Byte.\n");
    avrisp.WriteFuseLow(FUSE_EXTENDED);
    pc.printf("Fuse Extended Byte Readback = %x.\n",avrisp.ReadFuseExtended());
    
    pc.printf("Write Lock Byte.\n");
    avrisp.WriteLockByte(LOCK_BYTE);
    pc.printf("Lock Byte Readback = %x.\n",avrisp.ReadLockByte());    

    ifSuccessful = avrisp.ProgramFlash("/local/avr1");
    if(ifSuccessful)
    {    
        pc.printf("Program Flash: Successful.\n");
    }
    else
    {
        pc.printf("Program Flash: Failed.\n");
    }

    avrisp.LeaveProgrammingMode();
}
