//****************************************************************************/
// Description:
//
//  Program AVR chips with the AVR910 ISP (in-system programming) protocol,
//  using an mbed.
//
// This is a wrapper for AVR_ISP_Programmer_v2
//
//****************************************************************************/

#ifndef AVRISP_H
#define AVRISP_H

//****************************************************************************/
// Includes
//****************************************************************************/
#include "mbed.h"

//****************************************************************************/
// Definations for: ATMEGA1284p
//****************************************************************************/
#define SIGNATURE_BYTE_1    0x1E
#define SIGNATURE_BYTE_2    0x97
#define SIGNATURE_BYTE_3    0x05
#define PAGE_SIZE           128
#define NUM_PAGE            512

//****************************************************************************/
// Definations for programming
//****************************************************************************/
#define LSB(I) ((I) & 0xFF)
#define MSB(I) (((I) & 0xF00) >> 8)
#define TARGET_CLK 1000000L
#define MAX_PAGE_SIZE (PAGE_SIZE >> 1) //divide max page size by 2 to get number of words per page

class AVRISP
{
    public:
        AVRISP(PinName mosi, PinName miso, PinName sclk, PinName reset);
        bool EnableProgrammingMode();
        void LeaveProgrammingMode();
        int ReadChipSignatureByte1();
        int ReadChipSignatureByte2();
        int ReadChipSignatureByte3();
        void StillProgramming();
        void ChipErase();
        void WriteFuseLow(uint8_t fuseLow);
        int ReadFuseLow();
        void WriteFuseHigh(uint8_t fuseHigh);
        int ReadFuseHigh();
        void WriteFuseExtended(uint8_t fuseExtended);
        int ReadFuseExtended();
        void WriteLockByte(uint8_t lockByte);
        int ReadLockByte();
        void WriteProgramPage(uint16_t addr);
        void LoadProgramPage(uint16_t addr,uint8_t lowData,uint8_t highData);
        uint8_t ReadByte(FILE *file);
        void ReadProgramFlash(uint8_t addrMSB, uint8_t addrLSB);
        bool ProgramFlash(char *hexFileName);

    private:
        SPI*        spiPort;
        DigitalOut  *resetPin;
};

#endif
