#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include <math.h>       /* atan2 */

#define PI 3.14159265

#define DO P0_24    //CLK
#define DI P0_26    // MOSI
#define CS P0_10
#define DC P0_11
#define RST P0_17

class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk) {
        format(8,3);
        frequency(2000000);
    };
};


SPIPreInit mySpi(DI,NC,DO);
Adafruit_SSD1306_Spi oled(mySpi,DC,RST,CS,64,128);

DigitalOut myled1(P0_13);
DigitalOut myled2(P0_16);
DigitalOut myled3(P0_17);

DigitalIn myinput1(P0_6);
DigitalIn myinput2(P0_14);
DigitalIn myinput3(P0_22);

InterruptIn my_button(P0_1);
DigitalIn my_buttoninput(P0_1);

Serial uart(P0_4, P0_0);

AnalogIn myadc1(A0);
AnalogIn myadc2(A1);
AnalogIn myadc3(A3);

int mode=0;

void pressed()
{
    wait_ms(20);
    if(my_buttoninput==0) {
        if(mode==0)
            mode=1;
        else mode =0;
    }


}

int main()
{
    double x, y, z, result;
    myinput1.mode(PullNone);
    myinput2.mode(PullNone);
    myinput3.mode(PullNone);

    my_button.fall(&pressed);

    oled.clearDisplay();
    oled.setTextSize(2);
    oled.setTextCursor(0,0);

    while(1) {

        uart.printf("X: %2.3f V\r\n" ,myadc1.read()*3.3);
        uart.printf("Y: %2.3f V\r\n" ,myadc2.read()*3.3);
        uart.printf("Z: %2.3f V\r\n" ,myadc3.read()*3.3);
        x = (myadc1.read()*3.3-1.646)*3048.78;
        y = (myadc2.read()*3.3-1.642)*3025.72;
        z = (myadc3.read()*3.3-1.672)*3067.48;
        if(mode==0) {
            result = atan2(x,sqrt(z*z+y*y))*180/PI;
            uart.printf("Alpha: %2.3f degrees\r\n" ,result);
            oled.printf ("x %.1f d\r\n",result);
            result = atan2(y,sqrt(z*z+x*x))*180/PI;
            uart.printf("Beta: %2.3f degrees\r\n" ,result);
            oled.printf ("y %.1f d\r\n",result);
            result = atan2(z,sqrt(x*x+y*y))*180/PI;
            uart.printf("Gamma: %2.3f degrees\r\n" ,result);
            oled.printf ("z %.1f d\r\n",result);
            oled.printf ("  Mode A\r\n");

        } else {
            result = atan2 (x,z) * 180 / PI;
            uart.printf ("The arc tangent for (x=%f, z=%f) is %.4f degrees \r\n", x, z, result );
            oled.printf ("X %.1f D\r\n",result);
            oled.printf ("Y: %.0f mg\r\n",y);
//            result = atan2 (y,z) * 180 / PI;
//            uart.printf ("The arc tangent for (y=%f, z=%f) is %.4f degrees\r\n", y, z, result );
//            oled.printf ("Y %.1f D\r\n",result);
//            oled.printf ("Y: %.0f mg\r\n",y);
            oled.printf ("  Mode B\r\n");
        }
        myled1 = 1;
        myled2 = 0;
        myled3 = 1;

        oled.display();

        wait(1.5);
        oled.setTextCursor(0,0);
        oled.clearDisplay();
    }
}
