#include "mbed.h"
//#include "Adafruit_SSD1306.h"
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
// SSD1306 OLED AND Nucleo L432KC

#define Number 2048
#define XS 0.3235
#define YS 0.3235
#define ZS 0.3200
#define XB 1.5675
#define YB 1.5465
#define ZB 1.6100

#define DO A4
#define DI A6
#define CS D9
#define DC D11
#define RST D7

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED3);
AnalogIn adc1(A0);
AnalogIn adc2(A1);
AnalogIn adc3(A5);
float xa[Number],ya[Number],za[Number];



//
//class SPIPreInit : public SPI
//{
//public:
//    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk) {
//        format(8,3);
//        frequency(2000000);
//    };
//};
//
//SPIPreInit mySpi(DI,NC,DO);
//Adafruit_SSD1306_Spi oled(mySpi,DC,RST,CS,64,128);



int main()
{
    int x=0;


//    oled.clearDisplay();
//    oled.setTextSize(2);

    while(1) {

//        oled.printf("X %2.2lf g\r\n",double(adc1.read()*3300-offset_voltage)/sensitivity);
//        oled.printf("Y %2.2lf g\r\n",double(adc2.read()*3300-offset_voltage)/sensitivity);
//        oled.printf("Z %2.2lf g\r\n",double(adc3.read()*3300-offset_voltage)/sensitivity);
//        oled.display();

        wait_us(500);

        xa[x]=adc1.read()*3300/1000;
        ya[x]=adc2.read()*3300/1000;
        za[x]=adc3.read()*3300/1000;

        x++;
        myled = !myled;

        if(x>=Number) {

            myled = !myled;
            int c=0;
            while(c++<1) {

                pc.printf("X %2.3f g\r\n", (xa[c]-XB)/XS);
                pc.printf("Y %2.3f g\r\n", (ya[c]-YB)/YS);
                pc.printf("Z %2.3f g\r\n", (za[c]-ZB)/ZS);
                pc.printf("-----------------\r\n");

                wait(2);
            }
            x=0;
        }
    }
}
