#include "LightWeightSerialTransmit.h"

LWSerialTX::LWSerialTX(int baudRate)
{
    SerialConnection = new RawSerial(P1_27, P1_26);
    (*SerialConnection).baud(baudRate);
}

void LWSerialTX::NewFile()
{
    (*SerialConnection).putc(28);
    (*SerialConnection).putc(10);
    (*SerialConnection).putc(13);
}

void LWSerialTX::NewLine()
{
    (*SerialConnection).putc(10);
    (*SerialConnection).putc(13);
}

void LWSerialTX::Delimiter(Delimiters delimiter)
{
    (*SerialConnection).putc(delimiter);
}

void LWSerialTX::Transmit(double output)
{
    int outChar = 0;
    
    if (output < 0.0)
    {
        (*SerialConnection).putc('-');
        output *= -1.0;
    }
    if (output >= 1000.0)
    {
        outChar = output / 1000;
        (*SerialConnection).putc(outChar + 48);
        output -= outChar * 1000.0;
    }
    if (output >= 100.0)
    {
        outChar = output / 100;
        (*SerialConnection).putc(outChar + 48);
        output -= outChar * 100.0;
    }
    else if(outChar > 0)
    {
        (*SerialConnection).putc('0');
    }
    if (output >= 10.0)
    {
        outChar = output / 10;
        (*SerialConnection).putc(outChar + 48);
        output -= outChar * 10.0;
    }
    else if(outChar > 0)
    {
        (*SerialConnection).putc('0');
    }
    if (output >= 1.0)
    {
        outChar = output;
        (*SerialConnection).putc(outChar + 48);
        output -= outChar;
    }
    else
    {
        (*SerialConnection).putc('0');
    }
    if (output >= 0.1)
    {
        (*SerialConnection).putc('.');
        outChar = output * 10;
        (*SerialConnection).putc(outChar + 48);
        output -= (double)outChar / 10.0;
    }
    else
    {
        (*SerialConnection).putc('.');
        (*SerialConnection).putc('0');
    }
    if (output >= 0.01)
    {
        outChar = output * 100;
        (*SerialConnection).putc(outChar + 48);
        output -= (double)outChar / 100.0;
    }
    else
    {
        (*SerialConnection).putc('0');
    }
    if (output >= 0.001)
    {
        outChar= output * 1000;
        (*SerialConnection).putc(outChar + 48);
    }
}