#ifndef EQUATOR_STRUT_CONTROLLER_H
#define EQUATOR_STRUT_CONTROLLER_H

#include "mbed.h"

class EquatorStrut
{
public:
    EquatorStrut();
    void SetPower(double power);
    double GetPosition();
    double CurrentSpeed();
    double CurrentPower();
    void Home();
    void Enable();
    void Disable();
    bool IsEnabled();
    
private:
    DigitalIn* HallSensorState;
    InterruptIn* RGHSinInterrupt;
    InterruptIn* RGHCosInterrupt;
    InterruptIn* RGHSinFallingInterrupt;
    InterruptIn* RGHCosFallingInterrupt;
    InterruptIn* HallSensor;
    DigitalOut* ResetLine;
    PwmOut* PhaseA;
    PwmOut* PhaseB;
    Timer* RunningTime;
    
    void RGHSinRisingHandler();
    void RGHCosRisingHandler();
    void RGHSinFallingHandler();
    void RGHCosFallingHandler();
    void ActionEvent(bool currHigh, bool currSin);
    
    void DisableInterrupts();
    void EnableInterrupts();
    
    void HallEffectFall();
    
    volatile int position;
    volatile int direction;
    
    volatile double currentPower;
    
    volatile bool Homing;
    volatile bool HallTriggered;
    volatile bool Enabled;
    
    double SpeedInterval;
    int LastPosition;
    
    volatile bool SinHigh;
    volatile bool CosHigh;
    volatile bool LastSin;
    volatile bool LastHigh;
};

#endif