#include "mbed.h"
#include "TextLCD.h"
#include "RPG.h"
#include "Selection.h"
#include "Menu.h"
#include "Navigator.h"
#include <vector>
#include <string>

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
RPG rpg(p21,p22,p23); 

using namespace std;

// some functions to tie to selections
void toggleLED1() { led1 = !led1; }
void toggleLED2() { led2 = !led2; }
void toggleLED3() { led3 = !led3; }
void toggleLED4() { led4 = !led4; }
void resetLED()
{
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

int main() {
    // In using this library, the user declares "Menus", which are essentially arrays of "Selections".
    // Selections describe each individual selectable item. 
    // Selections can be tied to functions. Functions must output void and take in no arguments.
    // Selections can also have references to child menus.
    
    // It makes sense to declare a root menu first, but you don't have to. 
    // Menus should have an identifier (the argument in constructor). 
    Menu rootMenu("root"); 
    
    // Selections are added to menus through the Menu's "add" method.
    // If a function is to be executed when the RPG is depressed, make a REFERENCE to it. Otherwise null.
    // The second argument is its position - the will be deprecated soon.
    // The last is the text to display. *INCLUDE A SPACE IN THE BEGINNING, this is where the cursor goes. 
    // *This means the text is limited to 14 characters (not counting the space) with this display. 
    // **It is 14 not 15 for reasons pertaining to the implementation of the TextLCD library. 
    Menu ledMenu("LED menu"); 
    ledMenu.add(Selection(&toggleLED1, 0, NULL, " Toggle LED1")); // The function argument of selection can be added directly
    ledMenu.add(Selection(NULL, 1, NULL, " Toggle LED2"));        // It can also be set to NULL temporarily and changed later.
    ledMenu.selections[1].fun = &toggleLED2;                      // Useful for when functions are methods in other classes.
    ledMenu.add(Selection(&toggleLED3, 2, NULL, " Toggle LED3"));
    ledMenu.add(Selection(&toggleLED4, 3, NULL, " Toggle LED4"));
    ledMenu.add(Selection(&resetLED, 4, &rootMenu, " Go back"));  // always add a Selection at the end to point to the parent
    
    Menu aboutMenu("About Menu"); // about menu crediting us :)
    aboutMenu.add(Selection(NULL, 0, NULL, " Authors:"));
    aboutMenu.add(Selection(NULL, 1, NULL, " Ben Y & Tony T"));
    aboutMenu.add(Selection(NULL, 2, NULL, " ECE4180"));
    aboutMenu.add(Selection(NULL, 3, &rootMenu, " Go back"));
    
    // Selections to the root menu should be added last
    rootMenu.add(Selection(NULL, 0, &ledMenu, " LED MENU"));
    rootMenu.add(Selection(NULL, 1, NULL, " Dummy menu 1"));  // a dummy menu, doesn't do anything
    rootMenu.add(Selection(NULL, 2, &aboutMenu, " About menu"));   
    
    // Here is the heart of the system: the navigator. 
    // The navigator takes in a reference to the root, an interface, and a reference to an lcd
    Navigator navigator(&rootMenu, rpg, &lcd);
    
    while(1){
        navigator.poll(); // In a loop, call navigator's poll method to determine if the user is interacting with the rpg. 
    }
}