#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

// Mutex initialization
Mutex lcdLock;
Mutex speakerLock;
Mutex hitLock;

// AnalogIn initialization
AnalogIn photocell1(p15);
AnalogIn photocell2(p16);

// Speaker initialization
//PwmSpeaker speaker(p21);
 SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
 FILE *wave_file;
 AnalogOut DACout(p18);
 wave_player waver(&DACout);

// uLCD initialization
uLCD_4DGL uLCD(p28,p27,p26); // tx, rx, rst;

//Variable initializations
int c1=0, c2=0, s1=0; //photocell variables
int x=64, y=64, cursorRadius = 5; // cursor variables
int xr=0,yr=0, hitRadius = 7; // beatmap variables
int pnts = 0; int distAwaySqr = 100, distReqSqr = 101; int clearX=0, clearY=0; //handleHit variables
static void handleHit() {
    Thread::wait(50);
    
    hitLock.lock();
    clearX = xr;
    clearY = yr;
    hitLock.unlock();
    
    distAwaySqr = (x-clearX)*(x-clearX) + (y-clearY)*(y-clearY);
    distReqSqr = (cursorRadius+hitRadius)*(cursorRadius+hitRadius);
    if ( distAwaySqr <= distReqSqr ) {
        pnts++;
        Thread::wait(50);
        
        lcdLock.lock();
        uLCD.circle(clearX,clearY,hitRadius+3,RED);
        uLCD.circle(clearX,clearY,hitRadius+5,RED);
        lcdLock.unlock();
        Thread::wait(100);
        lcdLock.lock();
        uLCD.filled_circle(clearX,clearY,hitRadius+5,BLACK);
        lcdLock.unlock();
        
        Thread::wait(50);
        
        lcdLock.lock();
        uLCD.printf("pnts: %d\r", pnts);
        lcdLock.unlock();   
    }
    Thread::wait(50);
}

// Photocell thread
void phc_thread(void const *args) {
  while(1){
      c1 = (photocell1.read()- 0.06)*150;
      c1 = (c1>64) ? 64 : c1; //clamp below 64
      c1 = c1 - 32; // move between -32 and 31
      
      c2 = (photocell2.read() - 0.06)*150;
      c2 = (c2>64) ? 64 : c2; //clamp below 64
      c2 = c2 - 32; // move between -32 and 31
      Thread::wait(50);
  }
}

// player cursor thread
void cursor_thread(void const *args) {
  while(1){
    lcdLock.lock();
    uLCD.filled_circle(x,y,cursorRadius,BLACK);
    lcdLock.unlock();
    Thread::wait(50);
    
    x = 64-c1;
    y = 64-c2;   
    handleHit();
    
    lcdLock.lock();
    uLCD.filled_circle(x,y,cursorRadius,GREEN);
    lcdLock.unlock();
    Thread::wait(50);
  }
}

// beatmap thread
void bm_thread(void const *args) {
  while(1){
    hitLock.lock();
    xr = rand()%64 + 32;
    yr = rand()%64 + 32;
    hitLock.unlock();
    
    lcdLock.lock();
    uLCD.filled_circle(xr,yr,hitRadius,0xFF00FF);
    lcdLock.unlock();
    
    Thread::wait(4000);
    
    lcdLock.lock();
    uLCD.filled_circle(xr,yr,hitRadius,BLACK);
    lcdLock.unlock();
    Thread::wait(50);
  }
}

// Sound thread
void sound_thread(void const *args) {
  while(1){
    wave_file=fopen("/sd/wavfiles/CaveStory.wav","r");
    speakerLock.lock();
    waver.play(wave_file);
    speakerLock.unlock();
    fclose(wave_file); 
    Thread::wait(30000); // wait 30s before playing again
  }
  
}

int main() {
    uLCD.printf("pnts: %d\n\n\n\n\n\n\n\n\n\n\n\n\n\n", pnts);
    uLCD.printf("Chase pink circle!");
    uLCD.locate(0,0);
    Thread cursor(cursor_thread);
    Thread beatmap(bm_thread);
    Thread sound(sound_thread);
    Thread pcell(phc_thread);
    
    while (true) {
    }
}
