#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"

const char* SERVER_ADDRESS = "";
const int SERVER_PORT = 5005;
SDFileSystem fs(p5, p6, p7, p8, "sd");
//LocalFileSystem local("local");               // Create the local filesystem under the name "local"


int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketConnection socket;
    while (socket.connect(SERVER_ADDRESS, SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n\r", SERVER_ADDRESS, SERVER_PORT);
        wait(1);
    }
    
    FILE *file;
    char *buffer;
    unsigned long fileLen;

    //Open file
    file = fopen("/sd/IMG_0001.jpg", "rb");
    if (!file)
    {
        fprintf(stderr, "Unable to open file");
        exit(0);
    }
    
    //Get file length
    int size;

    fseek(file, 0, SEEK_END);
    size=ftell(file);
    fseek(file, 0, SEEK_SET);
    
    char send_buffer[size];
    while(!feof(file)) {
        fread(send_buffer, 1, sizeof(send_buffer), file);
        socket.send(send_buffer, sizeof(send_buffer));
    }
    
    free(buffer);
    printf("Done Sending\n\r");

    
    socket.close();
    eth.disconnect();
    
    while(true) {}
}
