#include "mbed.h"
#include "uLCD_4DGL.h"

uLCD_4DGL uLCD(p28, p27, p29);
AnalogIn AnalogX(p18);
AnalogIn AnalogY(p19);

int grid_field[7][7];
int xLocs[13];
int yLocs[13];
int round = 1;

//Cycles through different colors on RGB LED
SPI spi(p11, p12, p13);
DigitalOut latch(p15);
DigitalOut enable(p16);

//Methods
void lcdSetup();
void createGrid();
void drawGrid();
void fillGrid();
void initGrid();
void createGrid1();
void createGrid2();
void createGrid3();
void drawBorder();
void drawRoundInfo();
void moveBall();
void RGB_LED(int red, int green, int blue);

int main()
{
    lcdSetup();
    createGrid();

    // Round 1
    createGrid1();
    drawBorder();
    moveBall();
    round++;
    uLCD.cls();
    drawRoundInfo();
    wait(2);
    uLCD.cls();

    // Round 2
    createGrid();
    createGrid2();
    drawBorder();
    moveBall();
    round++;
    uLCD.cls();
    drawRoundInfo();
    wait(2);
    uLCD.cls();

    // Round 3
    createGrid();
    createGrid3();
    drawBorder();
    moveBall();
    round++;
    uLCD.cls();
    drawRoundInfo();
    wait(2);

}

void lcdSetup()
{
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    uLCD.color(BLUE);
    uLCD.text_width(2);
    uLCD.text_height(2);
    
    // Setup shiftbrite    
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;


    uLCD.cls();

    uLCD.printf("Maze Game\n");
    uLCD.printf("Try to get from the top, left to the bottom, right.\n");
    wait(3);
    uLCD.printf("\nLet's Begin..");
    wait(2);
    uLCD.cls();
}

void createGrid()
{
    uLCD.background_color(WHITE);
    uLCD.cls();

    // Max a 7x7 Grid
    // 18 pix width
    int count = 0;
    for(int i = 0; i < 127; i=i+18) {
        xLocs[count] = i;
        yLocs[count] = i;
        uLCD.line(i,0,i, 127, BLACK);
        uLCD.line(0, i,127, i, BLACK);
        count++;
    }


}

void initGrid()
{
    // Initialize all the grid locations with 0
    for(int a = 0; a < 8; a++) {
        for(int b = 0; b < 8; b++) {
            grid_field[a][b] = 0;
        }
    }
}

void createGrid1()
{
    initGrid();
    // For second, third row, fill in all but the end
    for(int c = 0; c < 6; c++) {
        grid_field[c][1] = 1;
        grid_field[c][2] = 1;
    }

    // For fifth, sixth row, fill 2nd to end
    for(int d = 1; d < 7; d++) {
        grid_field[d][4] = 1;
        grid_field[d][5] = 1;
    }
}

void createGrid2()
{
    initGrid();
    // For second, fill in all but the middle
    for(int c = 0; c < 7; c++) {
        if(c == 3) {
            continue;
        }
        grid_field[c][1] = 1;
    }

    //leave the 3rd row open
    //Fourth row
    for(int c = 1; c < 7; c++) {
        grid_field[c][3] = 1;
    }
    // Leave the fifth row open

    // For  sixth row, fill 2nd to end
    for(int d = 0; d < 7; d++) {
        if(d == 2) {
            continue;
        }

        grid_field[d][5] = 1;
    }
}

void createGrid3()
{
    initGrid();

    // For second, fill in all but the middle
    for(int c = 0; c < 7; c++) {
        if(c == 3) {
            continue;
        }
        grid_field[c][1] = 1;
    }

    //leave the 3rd row open
    //Fourth row
    for(int c = 0; c < 7; c++) {
        if(c == 1 || c == 3 || c == 5) {
            continue;
        }
        grid_field[c][3] = 1;
    }
    // Leave the fifth row open

    // For  sixth row, fill 2nd to end
    for(int d = 0; d < 7; d++) {
        if(d == 2 || d == 3 || d == 4) {
            continue;
        }

        grid_field[d][5] = 1;
    }
    grid_field[3][4] = 1;
    grid_field[3][6] = 1;
}

void drawBorder()
{
    for(int e = 0; e < 8; e++) {
        for(int f = 0; f < 8; f++) {
            if(grid_field[e][f] == 1) {
                //Draw a filled square in the block using the values in the locations
                uLCD.filled_rectangle(yLocs[e],yLocs[f], yLocs[e+1], yLocs[f+1], BLACK);
            }
        }
    }
}

void drawRoundInfo()
{
    uLCD.locate(0,0);
    uLCD.text_width(2);
    uLCD.text_height(2);
    if(round <= 3) {
        uLCD.printf("Finished!\n");
        uLCD.printf("Next up, Round %d\n", round);
    } else {
        uLCD.printf("Game Over!");
    }
}

void moveBall()
{
    int posX = 0;
    int posY = 0;
    bool win = false;
    bool movement = true;
    int prevPosX = 0;
    int prevPosY = 0;
    int radius = 4;
    int x, y, AnalogXReading, AnalogYReading;

    while(!win) {
        AnalogXReading = AnalogX.read()*128;
        AnalogYReading = AnalogY.read()*128;

        // Get reading
        if(AnalogXReading > 118) {
            if(posX > 0 && grid_field[posX-1][posY] == 0) {
                posX--;
                movement = true;
                RGB_LED(0, 50, 0);    
            } else {
                RGB_LED(50, 0, 0);    
            }
        }

        if(AnalogXReading < 10  && grid_field[posX+1][posY] == 0) {
            if(posX < 7) {
                posX++;
                movement = true;
                RGB_LED(0, 50, 0);    
            } else {
                RGB_LED(50, 0, 0);        
            }
        }

        if(AnalogYReading > 118 && grid_field[posX][posY - 1] == 0) {
            if(posY > 0) {
                posY--;
                movement = true;
                RGB_LED(0, 50, 0);    
            } else {
                RGB_LED(50, 0, 0);    
            }
        }
        if(AnalogYReading < 10 && grid_field[posX][posY + 1] == 0) {
            if(posY < 7) {
                posY++;
                movement = true;
                RGB_LED(0, 50, 0);    
            } else {
                RGB_LED(50, 0, 0);    
            }
        }

        // Redraw the ball
        if(movement) {
            x = (yLocs[prevPosX] + yLocs[prevPosX + 1]) / 2;
            y = (yLocs[prevPosY] + yLocs[prevPosY + 1]) / 2;
            uLCD.circle(x, y, radius, WHITE);
            x = (yLocs[posX] + yLocs[posX + 1]) / 2;
            y = (yLocs[posY] + yLocs[posY + 1]) / 2;
            uLCD.circle(x, y, radius, BLUE);
            prevPosX = posX;
            prevPosY = posY;
            movement = false;
        }
        wait(.2);

        if(posX == 6 && posY == 6) {
            win = true;
        }
    }
}

//Use SPI hardware to write color values to LED driver chip
void RGB_LED(int red, int green, int blue)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}