/*
 * Copyright (c) 2011 Paul van der Wielen, Pro-Serv
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to use
 * and implement the software for none commercial reason and usage only and
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Usage and assumptions:
 * coding as to interface an I2C LC Display modle available from:
 * Coptonix GmbH
 * Berlin 24.06.2008by @ less than Euro 13.-
  * which will interface to various HD44780 based units, 8Bit-Interface (16x2 or 20x4)
 *
 * Used device = LPC1768
 */
#include "mbed.h"
#include "lc_display.h"

DigitalOut flash(LED1);

int main() {

    // define some user characters for LCD display
    char MySymbol[2][9]= {{0x01,0x04,0x0e,0x1f,0x04,0x04,0x04,0x00,0x00},
                          {0x02,0x00,0x00,0x04,0x04,0x04,0x1f,0x0e,0x04}};
    // 
    _InitLCD();
    _WriteLCD(LCDType,0x01);
    _WriteLCD(WriteUserDefChar,MySymbol[0],9);
    _WriteLCD(WriteUserDefChar,MySymbol[1],9);
    while (1) {
        _WriteLCD(ClrDisplay);
        _WriteLCD(DisplayON_OFF, 1, 1, 0);
        _WriteLCD(WriteString, "Hello tester !", 14);
        _WriteLCD(SetCursor, 0x05);
        _WriteLCD(Shift, 1, 1);
        _WriteLCD(Delete, 1, 3, 4);
        _WriteLCD(SetCursor, 0x45);
        _WriteLCD(CharToLCD, 0x01);
        _WriteLCD(SetCursor, 0x14);
        _WriteLCD(CharToLCD, 0x02);
        _WriteLCD(SetCursor, 0x54);
        _WriteLCD(CharToLCD, 0x30);        
        _WriteLCD(Shift, 0, 0);
        // log to usb serial port, visible by Tera Term
        printf("Character ->%c<- at position %d, ram = %x\r\n", _ReadLCD(GetCharAtCur), _ReadLCD(GetCursorAdr), _ReadLCD(ReadRam));
        wait(4);
        _WriteLCD(ReturnHome);
        _WriteLCD(DisplayON_OFF, 0, 1, 1);
        wait(1);
        flash = !flash;
    }
}
