/*
 * Copyright (c) 2011 Paul van der Wielen, Pro-Serv
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to use
 * and implement the software for none commercial reason and usage only and
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Usage and assumptions:
 * coding as to interface an I2C LC Display modle available from:
 * Coptonix GmbH
 * Berlin 24.06.2008by @ less than Euro 13.-
  * which will interface to various HD44780 based units, 8Bit-Interface (16x2 or 20x4)
 *
 * Used device = LPC1768
 */
#include "mbed.h"

#define I2C_ADDR 0xfe
#define I2C_SPEED 400000

#define ClrDisplay 0x61
#define ReturnHome 0x62
#define SetCursor 0x63
#define CharToLCD 0x64
#define CMDToLCD 0x65
#define Delete 0x66
#define CopyToClipBoard 0x67
#define Paste 0x68
#define GetCursorAdr 0x69
#define GetCharAtCur 0x6a
#define ReadRam 0x6b
#define DisplayON_OFF 0x6c
#define Shift 0x6d
#define SetEntryMode 0x6e
#define SetFunction 0x6f
#define SetCGRAMAdr 0x70
#define SetGGRAMAdr 0x71
#define SaveLCDIni 0x73
#define WriteUserDefChar 0x74
#define SaveUserDefChr 0x75
#define WriteString 0x76
#define LCDType 0x77
  
I2C i2c(p28, p27);

void _InitLCD();
int  _ReadLCD(int Cmd);
void _WriteLCD(int Cmd, int par1, int par2, int par3);
void _WriteLCD(int Cmd, int par1, int par2);
void _WriteLCD(int Cmd, int par1);
void _WriteLCD(int Cmd);
void _WriteLCD(int Cmd, char *par1, int par2);

void _InitLCD() {
    i2c.frequency(I2C_SPEED);
}

int _ReadLCD(int Cmd) {

int j = 50;

    char data[2];
    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);
    i2c.read(I2C_ADDR, data, 2);
    i2c.stop();
    wait_us(j);
    return data[1];
}

void _WriteLCD(int Cmd, int par1, int par2, int par3) {

int j = 50;

    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);          // Set Command
    switch (Cmd) { 
        case DisplayON_OFF :
            i2c.write(0x08 + ((par1 & 0x01) << 2) + ((par2 & 0x01) << 1) + (par3 & 0x01));  // 0x00/0x01 for display, cursor and blinking
            break;
        case SetFunction :
            i2c.write(0x20 + ((par1 & 0x01) << 4) + ((par2 & 0x01) << 3) + ((par3 & 0x01) << 2));  // 0x00/0x01 for interface, lines and dots
            break;
        case Delete :
            j = 1000;
        case CopyToClipBoard :
            i2c.write(par1);        // line 1-4
            i2c.write(par2);        // position 1-20
            i2c.write(par3);        // count 1-20
            break;
        default :
            break;
    }
        
    i2c.stop();
    wait_us(j);
}

void _WriteLCD(int Cmd, int par1, int par2) {

int j = 50;

    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);          // Set Command
    switch (Cmd) {
        case Shift :
            i2c.write(0x10 + ((par1 & 0x01) << 3) + ((par2 & 0x01) << 2));                  // 0x00/0x01 cursor or display, 0x00/0x01 left or right
            break;
        case SetEntryMode :
            i2c.write(0x04 + ((par1 & 0x01) << 1) + (par2 & 0x01));                         // 0x00/0x01 for cursor move (increase / decrease), display (shifted / not shifted)
            break;
        default :
            break;
    }
        
    i2c.stop();
    wait_us(j);
}

void _WriteLCD(int Cmd, int par1) {

int j = 50;

    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);          // Set Command
    switch (Cmd) {
        case SetCursor :
            j = 500;
        case CharToLCD :
        case CMDToLCD :
        case SetCGRAMAdr :
        case SetGGRAMAdr :
            i2c.write(par1 & 0xff);                                                         // Put character at cursor position
            break;
        case SaveUserDefChr :
            i2c.write(par1 & 0x07);                                                         // Save user defined character 0-7
            break;
        case LCDType :
            i2c.write(par1 & 0x01);                                                         // set LCD type 0 = 4 x 16, 1 = 2 x 20
            break;
        default :
            break;
    }
        
    i2c.stop();
    wait_us(j);
}

void _WriteLCD(int Cmd) {

int j = 50;

    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);          // Set Command
    switch (Cmd) {
        case ClrDisplay :
            j = 2000;
            break;
        default :
            break;
    }   
    i2c.stop();
    wait_us(j);
}

void _WriteLCD(int Cmd, char *par1, int par2) {
// par2 != 0 -> use par2 else actual length of string
int i;
int j = 1000;

    i2c.start();
    i2c.write(I2C_ADDR);
    i2c.write(Cmd & 0xff);          // Set Command
    for (i = 0; i < (par2 != 0) ? par2 : strlen(par1); i++) {
        i2c.write(par1[i]);
    }
    i2c.stop();
    wait_us(j);
}
