/*
 * Copyright (c) 2011 Paul van der Wielen, Pro-Serv
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to use
 * and implement the software for none commercial reason and usage only and
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Usage and assumptions:
 * a RFID reader Model MF7(1.05) is configured in wiegand mode and attached 
 * ports per call to class (could be to p5 & p6 via a level converter as to
 * isolate the 5V source voltage from the 3.3V needed by MCU, this can easily
 * be done with diode in series with signal data0 and data1 of RFID reader and
 * pull up on MCU side.
 */
 
#include "mbed.h"
#include "wiegand.h"

DigitalOut flash(LED4);

Wiegand wiegand(p5,p6);

int main() {

    while(1) {
        if (wiegand.readable()) {
            // output our data read from rfid card reader to usb port for display
            // purposes
            printf ("Site = %x\r\n", wiegand.site());
            printf ("Data = %x\r\n", wiegand.data());
            printf ("RFID = %x\r\n", wiegand.rfid());
            wiegand.clear();
        }
        flash = !flash;
        wait(0.25);
    }
}
