/*
    Copyright (c) 2011 Pro-Serv
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    Usage and assumptions:
    Based on TSOP 1738 IR device, Vcc to 5Volt, Gnd to Gnd, Out has pull-up of 10K
    to Vcc and Out has diode (Cathode to Out) connected to pin (p16) (Anode to p16)
    and pin (p16) has mode PullUp
    
    This will allow a "standard" RC5 device to be used to read it transmitted codes.
    Still work in progress (in due time) to add newer rc6 devices
    
    Excellent source on RC5 protocol: http://www.ustr.net/infrared/infrared1.shtml
 */
 
#include "mbed.h"
#include "RC5Detect.h"

RC5Detect  rc5 ( p16, PullUp);

DigitalOut led1( LED1 );

int main() {

    //rc5.setAssertValue( 0 );
    rc5.setDelaySample(4820);
    rc5.setIntervalSample(1778);

    while(1) {
        if (rc5.getReadyState()) {
            printf("RC5 received, address = %d, command = %d\n", rc5.getRC5Address(), rc5.getRC5Command());
            rc5.setReadyState(0);
        }
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
}
