#if 1
/*
 * Copyright (c) 2012 Paul van der Wielen, Pro-Serv
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to use
 * and implement the software for none commercial reason and usage only and
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include <stdlib.h>
#include <string>

#include "mt382.h"

MT382  mt382 ( p21, p28, p27);

Serial pc(USBTX, USBRX);
Serial db(p28, p27);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

Ticker tx;

void mt_ticker() {
    if (mt382.getReading() != 0) {
        printf("\nNo data found or time-out!\n");
    } else {
        printf("Val_0 %.3lf, Val_1 %.3lf, Val_2 %.3lf, Val_3 %.3lf, Val_4 %.3lf, Val_5 %.3lf, Val_6 %.3lf\n", mt382.getValue(0), mt382.getValue(1), mt382.getValue(2), mt382.getValue(3), mt382.getValue(4), mt382.getValue(5), mt382.getValue(6));
    }
}
unsigned char tmpValue[128] = {0};

void dis_cnt (int x_cnt);

int main() {

    pc.baud(9600);
    db.baud(9600);
    //init device driver
    mt382.setComm(9600, 7, 2, 1);
    mt382.setTime(5.0);
    mt382.setMatch("1.8.1","1.8.2","2.8.1","2.8.2","1.7.0","2.7.0","24.2.1");
    // get first pass of MT382 'Smart Meter' data
    if (mt382.getReading() != 0) {
        printf("\nNo data found or time-out!\n");
    } else {
        printf("\nDone, char cnt %d !!\n", mt382.getCount());
        printf("Get data value by element\n");
        printf("Val_0 %.3lf, Val_1 %.3lf, Val_2 %.3lf, Val_3 %.3lf, Val_4 %.3lf, Val_5 %.3lf, Val_6 %.3lf\n", mt382.getValue(0), mt382.getValue(1), mt382.getValue(2), mt382.getValue(3), mt382.getValue(4), mt382.getValue(5), mt382.getValue(6));
        double * arr2 = mt382.getArray();
        printf("Get array with data by pointer\n");
        printf("Val_0 %.3lf, Val_1 %.3lf, Val_2 %.3lf, Val_3 %.3lf, Val_4 %.3lf, Val_5 %.3lf, Val_6 %.3lf\n", arr2[0], arr2[1], arr2[2], arr2[3], arr2[4], arr2[5], arr2[6]);
        printf("Raw data was: \n%s\n\n", mt382.getRaw());
    }
    // now setup collection interval
    tx.attach(&mt_ticker, 10.0);

    int i = 0;
    while(1) {
        
        while (pc.readable())
        {
            tmpValue[i++] = pc.getc();
            led1 = !led1;
        }
        wait(1);
        dis_cnt (i);
        if ((tmpValue[0] != 0x00) && (i == 5))    // or (i == 11)
        {
            pc.printf("%c%c%c%c%c" , 0x02,0x00,0x0C,0x00,0x03);
            for(int j=0; j<i; j++) { 
               db.printf("%c" , tmpValue[j]);
            }
            tmpValue[0] = 0x00;
            i = 0;
            wait(1);
            led1 = 0;
            wait(2);
            led2 = led3 = led4 = 0;           
        }
    
        led1 = 1;
        wait(60.2);
        led1 = 0;
        wait(.2);
    }
}

void dis_cnt (int x_cnt)
{
    switch (x_cnt)
    {
        case 0:
            led2 = led3 = led4 = 0;
            break;
        case 1:
            led2 = led3 = 0;
            led4 = 1;
            break;
        case 2:
            led2 = led4 = 0;
            led3 =  1;
            break;
        case 3:
            led2 = 0;
            led3 = led4 = 1;
            break;
        case 4:
            led2 = 1;
            led3 = led4 = 0;
            break;
        case 5:
            led2 = led4 = 1;
            led3 = 0;
            break;
        case 6:
            led2 = led3 = 1;
            led4 = 0;
            break;
        case 7:
            led2 = led3 = led4 = 1;
            break;
        default:
            break;
       }
}
#endif