/*
    Copyright (c) 2011 Pro-Serv
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    Usage and assumptions:
        the digital joystick device is directly attached to the used pins as per
        function call, common contact to ground, using the internal pull-up's
        but one can use external pull-up's too or even a small capaitor if device
        shows signs of contact bounce.
        
    Operation modes:
        By default it's using dynamic mode which means that the main program may
        not see the expected pressed joystick contact in it's scan loop as another
        joystick contact may already be active.
        Using the static mode will capture the first joystick contact untill it's
        been read by the getJoyValue function
        
    To do:
        Adding a callable service routine to be used by the main program loop
 */
 
#include "mbed.h"
#include "joy.h"

JoyRead  joy ( p21, p22, p23, p24, p25, PullUp); // center, 

DigitalOut led1(LED1);

int main() {

    // buffer first joystick movement, clear it upon read value
    joy.setJoyStatic(1);

    while(1) {
        if (joy.getJoyStatus()) {
            if (joy.getJoyKey(4)) {
                printf("Joy Down is active\r\n");
            }
            printf("Joy value %x\r\n", joy.getJoyValue());
        }
        led1 = 0;
        wait(0.2);
        led1 = 1;
        wait(0.2);
    }
}
