//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
//
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Dallas Semiconductor
// shall not be used except as stated in the Dallas Semiconductor
// Branding Policy.
//---------------------------------------------------------------------------
//
//  temp.c -   Application to find and read the 1-Wire Net
//             DS1920/DS1820/DS18S20 - temperature measurement.
//
//             This application uses the files from the 'Public Domain'
//             1-Wire Net libraries ('general' and 'userial').
//
//
//  Version: 2.00
//

#include <stdlib.h>
#include <stdio.h>
#include "owTemp.h"
#include "ownet.h"
#include "readDS1920.h"
#include "findtype.h"

// defines
#define MAXDEVICES         20

// global serial numbers
uchar FamilySN[MAXDEVICES][8];

// variables
int family_code;



owTemp::owTemp ()
{


}


void PrintSerialNum(uchar* buffer)
{
   int i;
   for(i=7; i>=0; i--)
   {
      printf("%02X", buffer[i]);
   }
}


//----------------------------------------------------------------------
//  Main Test for DS1920/DS1820 temperature measurement
//
void owTemp::Maingettemp( void )
{
   float current_temp;
   int i = 0;
   int NumDevices=0;
   int portnum = 0;
        
   
   //----------------------------------------
   // Introduction header
   printf("\r\n/---------------------------------------------\r\n");
   printf("  Temperature application DS1920/DS1820 - Version 1.00 \r\n"
          "  The following is a test to exercise a DS1920/DS1820.\r\n"
          "  Temperature Find and Read from a: \r\n"
          "  DS1920/DS1820 (at least 1)\r\n\r\n");

   printf("  Press any CTRL-C to stop this program.\r\n\r\n");
   printf("  Output [Serial Number(s) ........ Temp1(F)] \r\n\r\n");

    // attempt to acquire the 1-Wire Net
   portnum = owAcquireEx("1");
   
   // success
   printf("Port opened: %i\r\n", portnum);

   // Find the device(s)
   NumDevices = FindDevices(portnum, &FamilySN[0], 0x10, MAXDEVICES);
      
   if (NumDevices>0)
   {
      printf("\r\n");
      printf("Device(s) Found: \r\n");
      for (i = 0; i < NumDevices; i++)
      {
         PrintSerialNum(FamilySN[i]);
         printf("\r\n");
      }
      printf("\r\n\r\n");

        while (1)
        {
             // read the temperature and print serial number and temperature
             for (i = 0; i < NumDevices; i++)
             {
                if (ReadTemperature(portnum, FamilySN[i],&current_temp))
                {
                    float far = current_temp * 9.0 / 5.0 + 32.0;
                   PrintSerialNum(FamilySN[i]);
                   printf("      %5.1f Degrees Farenheight\r\n", far);
                  // converting temperature from Celsius to Fahrenheit
                }
                else
                   printf("     Error reading temperature, verify device present:%d\r\n",
                           (int)owVerify(portnum, FALSE));
             }
             printf("\r\n");
        }

   }
   else
      printf("\r\n\r\n\r\nERROR, device DS1920/DS1820 not found!\r\n");

   // release the 1-Wire Net
   owRelease(portnum);
}

