#include "mbed.h"
#include "ds2480.h"
#include "ownet.h"
#include "readDS18B20.h"
#include "findtype.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

// defines
#define MAXDEVICES         20
// global serial numbers
uchar FamilySN1[MAXDEVICES][8];

int main() {

    float temp = 0;
    int NumDevices = 0;
    
    if ( DS2480Detect(3) ) {
    
        NumDevices = FindDevices(3, &FamilySN1[0], 0x10, MAXDEVICES);
        
        printf("dev: %d\r\n", NumDevices);
        printf("sn:  ");
        PrintSerialNum(FamilySN1[0]);
        printf("\r\n");
        led1 = 0;
        while(1) {
        
            if (ReadDS18B20(3, FamilySN1[0],&temp)) {
                printf("      %7.3f %cC\r\n", temp, 0xf8);
            } else {
                printf("     Error, reading temperature\r\n"); 
            }
    
            led1 != led1;
            wait(1);
        }
    } else {
        printf("     Error, no DS2480 controller found\r\n");
    }
}