function output_data = Experiment_Example_MATLAB()
    figure(1);  clf;       % Create an empty figure to update later
    subplot(211)
    h1 = plot([0],[0]);
    
%    h1
    set(h1,'XData',[],'YData', []);
    ylabel('Position (counts)');
    subplot(212)
    h2 = plot([0],[0]);
    %h2.XData = []; h2.YData = [];
    set(h2,'XData',[],'YData',[]);
    ylabel('Velocity (counts/s)');
    
    % This function will get called any time there is new data from
    % the FRDM board. Data comes in blocks, rather than one at a time.
    function my_callback(new_data)
        t = new_data(:,1);   % time
        pos = new_data(:,2); % position
        vel = new_data(:,3); % velocity
        N = length(pos);
        tt = get(h1,'XData');
        yy = get(h1,'YData');
        
        tt(end+1:end+N) = t;   % Update subplot 1
        yy(end+1:end+N) = pos;
        set(h1,'XData',tt,'YData',yy);
        
        tt = get(h2,'XData');
        yy = get(h2,'YData');
        
        tt(end+1:end+N) = t;   % Update subplot 2
        yy(end+1:end+N) = vel;
        
        set(h2,'XData',tt,'YData',yy);
    end
    
    frdm_ip  = '192.168.1.100';     % FRDM board ip
    frdm_port= 11223;               % FRDM board port  
    params.callback = @my_callback; % callback function
    params.timeout  = 2;            % end of experiment timeout
    
    % The example program provided takes two arguments
    v1 = 1.0;           % pwm applied for first second 
    v2 = 0.0;           % pwm applied for second second
    input = [v1 v2];    % input sent to FRDM board
    output_size = 3;    % number of outputs expected
   
    output_data = RunExperiment(frdm_ip,frdm_port,input,output_size,params);
    
end



