#ifndef _STACKER_H
#define _STACKER_H
#include <../light_game.h>
class Stacker : public Light_Game {
    public:
        Stacker() {}
        virtual void init() {
            index_last = -1;
            index_cur = -1;
            next_goal = 29;
            forward = true;
            isDone = false;
            for(int i = 0; i < 30; i++) //reset all lights!
                strip.setPixelColor(i, 0, 0, 0);
            strip.show();
            wait(0.3);
        }
        
        virtual void update() { //dont need to declare this virtual but compiler throws warnings...
            strip.setPixelColor(index_last, 0, 0, 0);
            if(forward)
                strip.setPixelColor(++index_cur, 0, 0, 255);
            else
                strip.setPixelColor(--index_cur, 0, 0, 255);
                index_last = index_cur;
            strip.show();
            if(index_cur >= next_goal || index_cur == 0 && !forward)
                forward = !forward;
            wait((0.009 * next_goal));
        }
        
        virtual void btn1() {
            if(index_cur != next_goal) { //They lost!
                isDone = true;
                for(int i = 0; i < 30; i++)
                    strip.setPixelColor(i, 0, 255, 0);
                strip.show();
                wait(1); //let them see it before resetting.
                return;
            }
            index_last = -1; //reset last index.
            strip.setPixelColor(index_cur, 0, 255, 0);
            strip.show();
            index_cur = 0;
            forward = true;
            wait(0.1); //sometimes butons take time to press.
            if(--next_goal == 0) {//They win!
                for(int i = 0; i < 30; i++) {
                    if(i % 2 == 0)
                        strip.setPixelColor(i, 100, 100, 100);
                    else
                        strip.setPixelColor(i, 75, 100, 200);
                }
                strip.show();
            }
        }
        virtual void btn2() { btn1();} //Both buttons do the same thing.
        virtual bool isFinished() { return isDone; }
        private:
            int index_cur, index_last; //This is the index the moving light is currently on!
            int next_goal; //This is the next required light.
            bool forward, isDone;
};
#endif