#ifndef _LIGHT_SHOW_H
#define _LIGHT_SHOW_H

#include <../light_game.h>

class Light_Show : public Light_Game {
    public:
        Light_Show() {}
        virtual void init() {
            tail = -10;
            head = 0;
            int i;
            speed = 0.6; //1 second delay
            color = 0xFF0000;
            for(i = 0; i < 30; i++) //reset all lights!
                strip.setPixelColor(i, 0, 0, 0);
            strip.show();
            wait(0.5);
        }
        virtual void update() {
            strip.setPixelColor(head, (uint8_t) (color >> 16), (uint8_t) (color >> 8), (uint8_t) color);
            strip.setPixelColor(tail, 0, 0, 0);
            strip.show();
            wait(speed);   
            if(++head >= 30) {
                head = 0;
                if((color >>= 8) == 0)          //  Next color (R->G->B) ... past blue now?
                    color = 0xFF0000;
            }
            if(++tail >= 30) tail = 0;
        }
        
        virtual void btn1() {
            if((color >>= 2) == 0)
                color = 0xFF0000;
        }
        
        virtual void btn2() {
            speed -= 0.03;
            if(speed <= 0.00)
                speed = 1.00;
        }
        
        virtual bool isFinished() { return false; }
        
    private:
        float speed;
        uint32_t color;
        int tail, head;
        
};
#endif