#include "mbed.h"
#include "./DotStar/DotStar.h"
#include "./modes/light_show.h"
#include "./modes/stacker.h"
Serial pc(USBTX, USBRX);
InterruptIn btn1_(p8);
InterruptIn btn2_(p9);
Light_Game* mode = NULL;
void btn2Func() {
    if(::mode == NULL)  {
        ::mode = new Light_Show();
        return;
    }
    ::mode->btn1();
}
void btn1Func() {
    if(::mode == NULL)  {
        ::mode = new Stacker();
        wait(0.2); //wait for button to click or it will auto lose.
        return;
    }
    ::mode->btn2();
}
int main() {
    strip.begin();
    strip.show();
    btn1_.rise(&btn1Func);
    btn2_.rise(&btn2Func);
    wait(1);
    while(1) {
        pc.printf("Please enter a Light Option.\n");
        pc.printf("\t0 - Normal light demonstration\n");
        pc.printf("\t1 - Stacker game\n");
        while(mode == NULL) {
            if(!pc.readable()) continue;
            char raw = pc.getc(); //wait for their input!
            int opt = raw - 48;
            if(opt > 1) {
                pc.printf("Invalid Option!");
                continue;
            }
            switch(opt) {
                case 1://Stacker game.
                    mode = new Stacker();
                    break;
                
                default:
                    mode = new Light_Show();
            }
        }
        mode->init();
        while(!mode->isFinished()) {
            mode->update();
            if(pc.readable()) {
                pc.getc();
                break;
            }
        }
        mode->end();
        delete mode;
        mode = NULL;
    }
}