#include "mbed.h"
extern "C" void HardFault_Handler() { error("Hard Fault!\n"); }
#define debug 0
#define chatter 0
#define spiFreq 100000
#if 1 //pin&serial definitions
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalOut le[16] = { p15, p16, p17, p18, p19, p20,
p21, p22, p23, p24, p25, p26, p27, p28, p29, p30};
DigitalOut ce(p10); //Chip Enable
#endif
#if 1  //GLOBAL VARIABLES
    char registerValue[50];
    char tempVal2[50];
    int registerNumber;
    int registerValueINT;
    unsigned short split;
    char  parameters[100];
    int registr[16][6];
    int oldValue;
 /* GLOBAL VARIABLES*/   
#endif
#if 1 //FUNCTION DECLARATIONS
void registerUpdate(int leMask, int regNumber, int writeValue);
void registerWrite(int leMask, int regNumber,  uint32_t writeValue,  SPI spi);
#endif 
int main() 
{
#if 1 //RESET THE REGISTERS
ce = 0; myled1=1;myled2=1;myled3=1;myled4=1;wait(1);ce = 1;
myled1=0;myled2=0;myled3=0;myled4=0;
    for(int i=0; i<16; i++)
    {//active low; disable write
    le[i] = 1; 
}
#endif
pc.baud(115200); //Set the PC baud rate
#if 1 //read the config file
LocalFileSystem local("local");
FILE *config = fopen("/local/config.txt", "r"); //reading the config file

if (config==NULL) //blink myLed4 for read OK; myLed3 for FAIL
{
    #if debug 
    pc.printf("Cannot read config file!");
    #endif
}

int counts = 0; int x;
do
{
    x = fgetc(config);
    if(x == '=') //read until the equals sign
    {
        x = fgetc(config); //read through the space.
        fgets(parameters, 32, config); //read 32 characters(might need 33) for config      
        
        #if debug 
        pc.printf(" done reading from config  file  \n"); 
        #endif
        for(int i=0; i<16; i++)
        {
            registr[i][counts] = strtoul(parameters, NULL, 16);
        }
        ++counts; //increment the iteration counter
        
    }

} while(counts < 6);  //while(x != EOF); // // 
    #if debug 
pc.printf("trying to close  !");
#endif
fclose(config); //stop reading config file
    #if debug 
pc.printf("config file read complete.\n");
#endif
#endif
#if 1 //spi start up sequence
SPI spi(p5, NC, p7); // mosi, miso, sclk
#if debug 
pc.printf("spi started\n");
#endif
spi.format(8 , 0); //8 bits per transfer; MODE == 0
#if debug 
pc.printf(" format set\n");
#endif
spi.frequency(spiFreq); //Clock = 0.5MHz
#if debug 
pc.printf("frequency set\n"); 
#endif
#endif
#if 1 //register init sequence  
int y; 
for(y = 5; y > -1; y--) //write 6 times for registers 5 - 0
{
    #if chatter
    pc.printf("initializing register # %d with value of %x \n", y, registr[0][y] );
    #endif 
    registerWrite(0, y, registr[0][y], spi); //spi write the same init values to all boards via 0 mask
}
#endif
while(1) //main menu loop
    {
    
    uint32_t z, newValue=0;
    uint16_t leMask;
    settings: 
    #if chatter //Main Menu List
pc.printf("\n");
pc.printf("0. MAIN MENU\n");
pc.printf("1. 16-BIT INTEGER VALUE (INT)"); pc.printf(" * %i * :\n",(registr[0][0] & ~2147516415)>>15);
pc.printf("2. 12-BIT FRACTIONAL VALUE (FRAC)"); pc.printf(" * %i * :\n", (registr[0][0] & ~4294934535)>>3);
pc.printf("3. PRESCALER"); pc.printf(" * %i * :\n", ((registr[0][1] & ~4160749567)>>27));
pc.printf("4. 12-BIT PHASE VALUE (PHASE)"); pc.printf(" * %i * :\n", ((registr[0][1] & ~4160782335)>>15) );
pc.printf("5. 12-BIT MODULUS VALUE (MOD)"); pc.printf(" * %i * :\n",((registr[0][1] & ~4294934535)>>3));
pc.printf("6. NOISE MODE"); pc.printf(" * %i * :\n", ((registr[0][2]& ~2684354559)>>29));
pc.printf("7. MUXOUT"); pc.printf(" * %i * :\n", (registr[0][2]& ~3825205247)>>26);
pc.printf("8. REF DOUBLER"); pc.printf(" * %i * :\n", (registr[0][2]& ~4261412863)>>25);
pc.printf("9. REF DIVIDE BY 2"); pc.printf(" * %i * :\n", ((registr[0][2] & ~4278190079)>>24));
pc.printf("10. 10-BIT R COUNTER"); pc.printf(" * %i * :\n", (registr[0][2]& ~4278206463)>>14);  
pc.printf("11. DOUBLE BUFFERING"); pc.printf(" * %i * :\n",(registr[0][2]& ~4294959103)>>13);
pc.printf("12. CHARGE PUMP CURRENT"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294959615)>>9);
pc.printf("13. LDF"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294967039)>>8);
pc.printf("14. LDP"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294959103)>>7);
pc.printf("15. PD POLARITY"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294967231)>>6);
pc.printf("16. POWER DOWN"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294967263)>>5);
pc.printf("17. CP THREE STATE"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294959103)>>4);
pc.printf("18. COUNTER RESET"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294967287)>>3);
pc.printf("19. CYCLE SLIP REDUCTION"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294705151)>>18);
pc.printf("20. CLK DIV MODE"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294868991)>>15);
pc.printf("21. 12-BIT CLOCK DIVIDER VALUE"); pc.printf(" * %i * :\n", (registr[0][2]& ~4294934535)>>3);
pc.printf("22. FEEDBACK SELECT"); pc.printf(" * %i * :\n",(registr[0][4]& ~4286578687)>>23);
pc.printf("23. RG DIVIDER SELECT"); pc.printf(" * %i * :\n",(registr[0][4]& ~4287627263)>>20);
pc.printf("24. 8-BIT BAND SELECT CLOCK DIVIDER VALUE"); pc.printf(" * %i * :\n",(registr[0][4]& ~4293922815)>>12);
pc.printf("25. VCO POWER DOWN"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294965247)>>11);
pc.printf("26. MTLD"); pc.printf(" * %i * :\n",(registr[0][4]& ~4294966271)>>10);
pc.printf("27. AUX OUTPUT SELECT"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294966783)>>9);
pc.printf("28. AUX OUTPUT ENABLE"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294967039)>>8);
pc.printf("29. AUX OUTPUT POWER"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294967103)>>6);
pc.printf("30. RF OUTPUT ENABLE"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294967263)>>5);
pc.printf("31. OUTPUT POWER"); pc.printf(" * %i * :\n", (registr[0][4]& ~4294967271)>>3);
pc.printf("32. LD PIN MODE"); pc.printf(" * %i * :\n",        (registr[0][5]& ~4282384383)>>22);
pc.printf("33. RAW WRITE \n"); 
pc.printf("34. LE BOARD MASK"); pc.printf( " * %x *\n", leMask); 
pc.printf("35.REGISTER VALUE TABLE\n"); 
        
        pc.printf("Select option: ");
        #endif
        pc.scanf("%i", &z);pc.printf("%i\n", z);
        switch(z)
        {
            #if 1 //16-BIT INTEGER VALUE
            case 1: 
            #if chatter
            pc.printf("ENTER NEW INTEGER VALUE: ");
            #endif
            pc.scanf("%i", &z);pc.printf("%i\n", z);
            for(int i=0; i<16; i++)//if prescaler(c)is 4/5 min 16-bit is 23
            {
                while( (z<23) & ((registr[i][1]&(~4160749567))>>27)==0 ) 
                {
                    #if chatter
                    pc.printf("Must be greater than 23");
                    #endif
                    pc.scanf("%i", &z);pc.printf("%i\n", z);
                }
            }
            for(int i=0; i<16; i++)
            {//if prescaler(reg1) is 8/9 min 12-bit is 75
                while( (z<75) & ((registr[i][1]&(~4160749567))>>27)==1 ) 
                {
                    #if chatter
                    pc.printf("Must be greater than 75");
                    #endif
                    pc.scanf("%i", &z);pc.printf("%i\n", z);
                }
            }
            while( z>65535 ) 
            {//if greater than max error
                #if chatter
                pc.printf("Must be less than 65535");
                #endif
                pc.scanf("%i", &z);pc.printf("%i\n", z);
            }
            for(int i=0; i<16; i++)
            {//update all board registers
                
                if( (~leMask & (1 << i) ) > 0)//if a board is write enabled
                {//update that particular board register
                    registr[i][0] = (registr[i][0] & 2147516415) | (z<<15);
                    newValue=registr[i][0];
                }
                 
            }
            registerWrite(leMask, 0, newValue, spi);goto settings; //write updated value
            #endif
            
            #if 1 //12-BIT FRACTIONAL VALUE (FRAC)
            case 2:
            #if chatter
            pc.printf("ENTER NEW FRAC VALUE(0-4095): ");
            #endif
            pc.scanf("%i", &z);pc.printf("%i\n", z);
            while( z > 4095)
            {//if 12 bit fractional greater than 4095 error
                #if chatter
                pc.printf("MUST BE LESS THAN 4095");
                #endif
                pc.scanf("%i", &z);pc.printf("%i\n", z);
            }           

            for(int i=0; i<16; i++)
            {//update all board registers
                
                if( (~leMask & (1 << i) ) > 0)//if board write is enabled
                {//update that particular register value
                registr[i][0] = (registr[i][0] & 4294934535) | (z<<3);
                newValue=registr[i][0];
                }
                 
            }
            registerWrite(leMask, 0, newValue, spi);goto settings;
            #endif
            
            #if 1 //PRESCALER
            case 3:
            #if chatter
            pc.printf("0. PRESCALER 4/5\n");
            pc.printf("1. PRESCALER 8/9\n");
            #endif
            pc.scanf("%i", &z);pc.printf("%i\n", z);
            for(int i=0; i<16; i++)//upadte registers
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][1] = ((registr[i][1] & 4160749567) | (z<<27) );
                    newValue=registr[i][1];
                }
            }
            registerWrite(leMask, 1, newValue, spi);goto settings;
            #endif
            
            #if 1 //12-BIT PHASE VALUE (PHASE)
            case 4:
            #if chatter
            pc.printf("ENTER NEW PHASE VALUE: ");
            #endif
            pc.scanf("%i", &z);pc.printf("%i\n", z);
            while( z>4095 )
            {//phase must be less than 4095
                #if chatter
                pc.printf("MUST BE LESS THAN 4095 ");
                #endif
                pc.scanf("%i", &z);
                #if chatter
                pc.printf("%i\n", z);
                #endif
            }
            
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {   
                    registr[i][1] = ((registr[i][1] & 4160782335) | (z<<15) );
                    newValue=registr[i][1];
                    oldValue= registr[i][0];
                }
            }
            registerWrite(leMask, 1, newValue, spi);
            registerWrite(leMask, 0, oldValue, spi);goto settings;
            #endif
            
            #if 1 //12-BIT MODULUS VALUE (MOD)
            case 5:
            #if chatter
            pc.printf("ENTER NEW MODULUS VALUE: ");
            #endif
            pc.scanf("%i", &z);pc.printf("%i\n", z);
            while( z>4095 )
            {//phase must be less than 4095
                #if chatter
                pc.printf("MUST BE LESS THAN 4095 ");
                #endif
                pc.scanf("%i", &z);pc.printf("%i\n", z);
            }
            for(int i=0;i<16;i++)//update registers
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][1] = ((registr[i][1] & 4294934535) | (z<<3) );
                    newValue=registr[i][1];
                }
            }
            registerWrite(leMask, 1, newValue, spi);goto settings;
            #endif
            
            #if 1 //NOISE MODE
            case 6:
            #if chatter
            pc.printf("0. LOW NOISE MODE\n");
            pc.printf("1. LOW SPUR MODE\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][1] = ((registr[i][2] & 2684354559) | (z<<3) );
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //MUXOUT
            case 7:
            #if chatter
                pc.printf("0. THREE-STATE OUTPUT\n");
                pc.printf("1. DVdd\n");
                pc.printf("2. DGND\n");
                pc.printf("3. R DIVIDER OUTPUT\n");
                pc.printf("4. N DIVIDER OUTPUT0\n");
                pc.printf("5. ANALOG LOCK DETECT\n");
                pc.printf("6. DIGITAL LOCK DETECT\n");
           #endif 
                pc.scanf("%i", &z);
                #if chatter
                pc.printf("%i\n", z);
                #endif
                for(int i=0; i<16; i++)//register update
                {
                    
                    if( (~leMask & (1 << i) ) > 0)
                    {
                        registr[i][2] = (registr[i][2]&3825205247) | (z<<26);
                        newValue = registr[i][2];
                    }
                }
                registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //REF DOUBLER
            case 8:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4261412863) | (z <<25);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //REF DIVIDE BY 2
            case 9:
            #if chatter
            pc.printf("0. DISABLED");
            pc.printf("1. ENABLED");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = ((registr[i][2] & 4278190079) | (z<<24));
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //10-BIT R COUNTER
            case 10:
            #if chatter
            pc.printf("ENTER NEW R COUNTER VALUE (0-1023): ");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4278206463) | (z <<14);
                    newValue = registr[i][2];
                }
            }           
            
            registerWrite(leMask, 2, newValue, spi);goto settings;          
            #endif
            
            #if 1 //DOUBLE BUFFERING
            case 11:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294959103) | (z <<13);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //CHARGE PUMP CURRENT
            case 12:
            #if chatter
            pc.printf("0.  0.31 mA\n");
            pc.printf("1.  0.63 mA\n");
            pc.printf("2.  0.94 mA\n");
            pc.printf("3.  1.25 mA\n");
            pc.printf("4.  1.56 mA\n");
            pc.printf("5.  1.88 mA\n");
            pc.printf("6.  2.19 mA\n");
            pc.printf("7.  2.50 mA\n");
            pc.printf("8.  2.81 mA\n");
            pc.printf("9. 3.13 mA\n");
            pc.printf("10. 3.44 mA\n");
            pc.printf("11. 3.75 mA\n");
            pc.printf("12. 4.06 mA\n");
            pc.printf("13. 4.38 mA\n");
            pc.printf("14. 4.59 mA\n");
            pc.printf("15. 5.00 mA\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294959615) | (z <<9);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //LDF
            case 13:
            #if chatter
            pc.printf("0. FRAC-N\n");
            pc.printf("1. INT-N\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294967039) | (z <<8);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //LDP
            case 14:
            #if chatter
            pc.printf("0. 10ns\n");
            pc.printf("1. 6ns\n");
            #endif 
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294959103) | (z <<7);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //PD POLARITY
            case 15:
            #if chatter
            pc.printf("0. NEGATIVE\n");
            pc.printf("1. POSITIVE\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//regsiter update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294967231) | (z <<6);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //POWER DOWN
            case 16:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register upadte
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294967263) | (z <<5);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //CP THREE STATE
            case 17:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294959103) | (z <<4);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //COUNTER RESET
            case 18:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][2]&4294967287) | (z <<3);
                    newValue = registr[i][2];
                }
            }
            registerWrite(leMask, 2, newValue, spi);goto settings;
            #endif
            
            #if 1 //CYCLE SLIP REDUCTION
            case 19:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][3]&4294705151) | (z <<18);
                    newValue = registr[i][3];
                }
            }
            registerWrite(leMask, 3, newValue, spi);goto settings;
            #endif
                  
            #if 1 //CLK DIV MODE
            case 20:
            #if chatter
            pc.printf("0. CLOCK DIVIDER OFF\n");
            pc.printf("1. FAST-LOCK ENABLE\n");
            pc.printf("2. RESYNC ENABLE\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][3] = (registr[i][3]&4294868991) | (z <<15);
                    newValue = registr[i][3];
                }
            }
            registerWrite(leMask, 3, newValue, spi);goto settings;
            #endif
            
            #if 1 //12-BIT CLOCK DIVIDER VALUE
            case 21:
            #if chatter
            pc.printf("ENTER NEW CLOCK DIVIDER VALUE(0-4095): ");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][2] = (registr[i][3]&4294934535) | (z <<3);
                    newValue = registr[i][3];
                }
            }
            registerWrite(leMask, 3, newValue, spi);goto settings;
            #endif
            
            #if 1 //FEEDBACK SELECT
            case 22:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4286578687) | (z <<23);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //RG DIVIDER SELECT
            case 23:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4287627263) | (z <<20);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //8-BIT BAND SELECT CLOCK DIVIDER VALUE
            case 24:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4293922815) | (z <<12);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //VCO POWER DOWN
            case 25:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294965247) | (z <<11);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //MTLD
            case 26:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294966271) | (z <<10);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //AUX OUTPUT SELECT
            case 27:
            #if chatter
            pc.printf("0. DIVIDED\n");
            pc.printf("1. FUNDAMETNAL\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//rebgister update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294966783) | (z <<9);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //AUX OUTPUT ENABLE
            case 28:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294967039) | (z <<8);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //AUX OUTPUT POWER
            case 29:
            #if chatter
            pc.printf("0. -4 dBm\n");
            pc.printf("1. -1 dBm\n");
            pc.printf("2. 2 dBm\n");
            pc.printf("3. 5 dBm\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294967103) | (z <<6);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //RF OUTPUT ENABLE
            case 30:
            #if chatter
            pc.printf("0. DISABLED\n");
            pc.printf("1. ENABLED\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {   
                                        #if debug
                                            pc.printf("board value updated: %x \n", (~leMask & (1 << i) > 0) );
                                            pc.printf("LE MASK INVERT: %x \n", ~leMask);
                                            pc.printf("AFTER OFFSET: %x \n", (~leMask & (1 << i) ) );
                                        #endif
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294967263) | (z <<5);
                    newValue = registr[i][4];
                                        #if debug
                                            pc.printf("table updated \n");
                                        #endif
                }

            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
            
            #if 1 //OUTPUT POWER
            case 31:
            #if chatter
            pc.printf("0. -4 dBm\n");
            pc.printf("1. -1 dBm\n");
            pc.printf("2. 2 dBm\n");
            pc.printf("3. 5 dBm\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//register update
            {
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][4] = (registr[i][4]&4294967271) | (z <<3);
                    newValue = registr[i][4];
                }
            }
            registerWrite(leMask, 4, newValue, spi);goto settings;
            #endif
        
            #if 1 //LD PIN MODE
            case 32:
            #if chatter
            pc.printf("0. LOW\n");
            pc.printf("1. DIGITAL LOCK DETECT\n");
            pc.printf("2. LOW\n");
            pc.printf("2. HIGH\n");
            #endif
            pc.scanf("%i", &z);
            #if chatter
            pc.printf("%i\n", z);
            #endif
            for(int i=0; i<16; i++)//regisgter update
            {
                
                if( (~leMask & (1 << i) ) > 0)
                {
                    registr[i][5] = (registr[i][5]&4282384383) | (z <<22);
                    newValue = registr[i][5];
                }
            }
            registerWrite(leMask, 5, newValue, spi);goto settings;
            #endif
            
            #if 1 //RAW WRITE
            case 33:
            int a, b;
            #if chatter
            pc.printf("RAW WRITE HEX: ");
            #endif
            pc.scanf("%x", &a);
            #if chatter
            pc.printf("%i\n", a);
            pc.printf("TO REGISTER #: ");
            #endif
            pc.scanf("%i", &b);
            #if chatter
            pc.printf("%i\n", b);
            #endif
            registerWrite(leMask, b, a, spi);
            goto settings;
            #endif
            
            #if 1 //MASK
            case 34:
            #if chatter
            pc.printf("ENTER BOARD WRITE ENABLE MASK: ");
            #endif
            pc.scanf("%x", &leMask);
            #if chatter
            pc.printf("%x\n", leMask);
            #endif
            goto settings;
            #endif
        
            #if 1 //VALUE TABLE
            case 35:
            for(int i=0; i<16; i++)
            {
                #if chatter
            pc.printf("REGISTER #%i: ", i);
                pc.printf(" %x ", registr[i][0]);
                pc.printf(" %x ", registr[i][1]);
                pc.printf(" %x ", registr[i][2]);
                pc.printf(" %x ", registr[i][3]);
                pc.printf(" %x ", registr[i][4]);
                pc.printf(" %x \n", registr[i][5]);
                #endif
            }

            goto settings;
            #endif
        }
    
    }

}
    
void registerWrite(int leMask, int regNumber,  uint32_t writeValue,  SPI spi)
{
                                        #if debug //display current mask before you write
            pc.printf("the current leMask is: %d \n", leMask);
        #endif
        for(int i=0; i<16; i++)
        {//set load enable according to mask
                                        
            le[i] = (leMask&(1 << i ))>>i;
                                        #if debug //display which boards are curre enabled
                pc.printf("le for board %i is %i\n", i, le[i].read());
            #endif
        }
    
    wait(0.00000002); //ensure 20ns LE to CLK delay
    
registerUpdate(leMask, regNumber, writeValue);
    
    
    
/*  WRITE TO THE REGISTERS */
//the registers are 32 bits longs and the board takes
//8 bits per transfer so the value to be written must be split 
//into 4 equal parts. 
/*
    split = writeValue >> 24;
    spi.write(split); //write to registers
    split = (writeValue<< 8) >> 24;
    spi.write(split); //write the second half registers
    split = (writeValue<< 16) >> 24;
    spi.write(split); //write the second half registers
    split = (writeValue<< 24) >> 24;
    spi.write(split); //write the second half registers
*/
spi.write( (writeValue & 0xFF000000) >> 24 ); //write to registers
 wait_us(1); //ensure 20ns LE to CLK delay
spi.write( (writeValue & 0xFF0000) >> 16); //write to registers
 wait_us(1); //ensure 20ns LE to CLK delay
spi.write( (writeValue & 0xFF00) >> 8); //write to registers
 wait_us(1); //ensure 20ns LE to CLK delay
spi.write( (writeValue & 0xFF) >> 0); //write to registers
 wait_us(1); //ensure 20ns LE to CLK delay

                                        #if debug //display which boards are curr enabled
                                                    pc.printf("Value %x copied to register %i. \n", writeValue, regNumber);
                                                #endif      
            for(int i=0; i<16; i++)
            {//disable all boards
                le[i] = 1;      
                                                        #if debug //display which boards are curre enabled
                pc.printf("le for board after reset %i is %i\n", i, le[i].read());
            #endif
            }
            
    wait(0.00000002); //ensure 20ns LE to CLK delay  
    
    #if 1 //if double buffering is on
    for(int i=0; i<16; i++)
        {
            if ( (registr[i][2]& ~4294959103)>>13 == 1) 
            {
                                                #if debug //display current mask before you write
                    pc.printf("the current leMask is: %d \n", leMask);
                #endif
                for(int i=0; i<16; i++)
                {//set load enable according to mask
                                                
                    le[i] = (leMask&(1 << i ))>>i;
                                                #if debug //display which boards are curre enabled
                        pc.printf("le for board %i is %i\n", i, (leMask&(1 << i ))>>i);
                    #endif
                }
            
            wait(0.00000002); //ensure 20ns LE to CLK delay
            
                //registerUpdate(leMask, regNumber, writeValue);
        /*  WRITE TO THE REGISTERS */
        //the registers are 32 bits longs and the board takes
        //8 bits per transfer so the value to be written must be split 
        //into 4 equal parts. 
            split = (writeValue & 0xFF);
            spi.write(split); //write to registers
            split = (writeValue &  0xFF00) >> 8;
            spi.write(split); //write the second half registers
            split = (writeValue & 0xFF0000) >> 16;
            spi.write(split); //write the second half registers
            split = (writeValue & 0xFF000000) >> 24;
            spi.write(split); //write the second half registers
                                                #if debug //display which boards are curr enabled
                                                            pc.printf("Value %x copied to register %i. \n", writeValue, regNumber);
                                                        #endif      
            
                    for(int i=0; i<16; i++)
                    {//disable all boards
                        le[i] = 1;      
                    }
                    
            wait(0.00000002); //ensure 20ns LE to CLK delay  
            }
            

        }
    #endif
    }   
    
void registerUpdate(int leMask, int regNumber, int writeValue)
{
    for(int i=0;i<16; i++)
    {
        if( (~leMask & (1<<i) ) > 0 )//... write shit to keep track of every register's contents.
        registr[i][regNumber] = writeValue; //update copy of registers
    }
}

