#include "mbed.h"
#include "player.h"
#include "DebouncedInterrupt.h"


extern char list[20][50];            //song list
extern unsigned char vlume;     //vlume
extern unsigned char vlumeflag; //set vlume flag
extern char index;              //song play index
extern char index_MAX;          //how many song in all
extern playerStatetype  playerState;

Serial pc(SERIAL_TX, SERIAL_RX);

Player player;

DebouncedInterrupt KEY_PS(D3);
InterruptIn KEY_Next(D4);


void riseFlip()
{
    if(player.mode()) {
        if(playerState == PS_PAUSE) playerState = PS_PLAY;
        else playerState = PS_PAUSE;
    }
}

void Next()
{
    if(player.mode())playerState = PS_STOP;
    //player.select_list();
}


int main()
{

    player.setup();
    KEY_PS.attach(&riseFlip ,IRQ_RISE ,100);
    KEY_Next.fall(&Next);
    player.begin();
    if(player.mode())player.print_list();
    else player.letplay();
    while(1) {
        player.playFile(list[index]);
    }
    //int i = player.getGX();
    //printf("%d\n",i);
}


